@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RequestValidator].
 */
@PulumiTagMarker
public class RequestValidatorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RequestValidatorArgs = RequestValidatorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RequestValidatorArgsBuilder.() -> Unit) {
        val builder = RequestValidatorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RequestValidator {
        val builtJavaResource = com.pulumi.aws.apigateway.RequestValidator(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RequestValidator(builtJavaResource)
    }
}

/**
 * Manages an API Gateway Request Validator.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apigateway.RequestValidator("example", {
 *     name: "example",
 *     restApi: exampleAwsApiGatewayRestApi.id,
 *     validateRequestBody: true,
 *     validateRequestParameters: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apigateway.RequestValidator("example",
 *     name="example",
 *     rest_api=example_aws_api_gateway_rest_api["id"],
 *     validate_request_body=True,
 *     validate_request_parameters=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ApiGateway.RequestValidator("example", new()
 *     {
 *         Name = "example",
 *         RestApi = exampleAwsApiGatewayRestApi.Id,
 *         ValidateRequestBody = true,
 *         ValidateRequestParameters = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigateway.NewRequestValidator(ctx, "example", &apigateway.RequestValidatorArgs{
 * 			Name:                      pulumi.String("example"),
 * 			RestApi:                   pulumi.Any(exampleAwsApiGatewayRestApi.Id),
 * 			ValidateRequestBody:       pulumi.Bool(true),
 * 			ValidateRequestParameters: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RequestValidator;
 * import com.pulumi.aws.apigateway.RequestValidatorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RequestValidator("example", RequestValidatorArgs.builder()
 *             .name("example")
 *             .restApi(exampleAwsApiGatewayRestApi.id())
 *             .validateRequestBody(true)
 *             .validateRequestParameters(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apigateway:RequestValidator
 *     properties:
 *       name: example
 *       restApi: ${exampleAwsApiGatewayRestApi.id}
 *       validateRequestBody: true
 *       validateRequestParameters: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_request_validator` using `REST-API-ID/REQUEST-VALIDATOR-ID`. For example:
 * ```sh
 * $ pulumi import aws:apigateway/requestValidator:RequestValidator example 12345abcde/67890fghij
 * ```
 */
public class RequestValidator internal constructor(
    override val javaResource: com.pulumi.aws.apigateway.RequestValidator,
) : KotlinCustomResource(javaResource, RequestValidatorMapper) {
    /**
     * Name of the request validator
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ID of the associated Rest API
     */
    public val restApi: Output<String>
        get() = javaResource.restApi().applyValue({ args0 -> args0 })

    /**
     * Boolean whether to validate request body. Defaults to `false`.
     */
    public val validateRequestBody: Output<Boolean>?
        get() = javaResource.validateRequestBody().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Boolean whether to validate request parameters. Defaults to `false`.
     */
    public val validateRequestParameters: Output<Boolean>?
        get() = javaResource.validateRequestParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object RequestValidatorMapper : ResourceMapper<RequestValidator> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigateway.RequestValidator::class == javaResource::class

    override fun map(javaResource: Resource): RequestValidator = RequestValidator(
        javaResource as
            com.pulumi.aws.apigateway.RequestValidator,
    )
}

/**
 * @see [RequestValidator].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RequestValidator].
 */
public suspend fun requestValidator(
    name: String,
    block: suspend RequestValidatorResourceBuilder.() -> Unit,
): RequestValidator {
    val builder = RequestValidatorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RequestValidator].
 * @param name The _unique_ name of the resulting resource.
 */
public fun requestValidator(name: String): RequestValidator {
    val builder = RequestValidatorResourceBuilder()
    builder.name(name)
    return builder.build()
}
