@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.RequestValidatorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an API Gateway Request Validator.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apigateway.RequestValidator("example", {
 *     name: "example",
 *     restApi: exampleAwsApiGatewayRestApi.id,
 *     validateRequestBody: true,
 *     validateRequestParameters: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apigateway.RequestValidator("example",
 *     name="example",
 *     rest_api=example_aws_api_gateway_rest_api["id"],
 *     validate_request_body=True,
 *     validate_request_parameters=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ApiGateway.RequestValidator("example", new()
 *     {
 *         Name = "example",
 *         RestApi = exampleAwsApiGatewayRestApi.Id,
 *         ValidateRequestBody = true,
 *         ValidateRequestParameters = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigateway.NewRequestValidator(ctx, "example", &apigateway.RequestValidatorArgs{
 * 			Name:                      pulumi.String("example"),
 * 			RestApi:                   pulumi.Any(exampleAwsApiGatewayRestApi.Id),
 * 			ValidateRequestBody:       pulumi.Bool(true),
 * 			ValidateRequestParameters: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RequestValidator;
 * import com.pulumi.aws.apigateway.RequestValidatorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RequestValidator("example", RequestValidatorArgs.builder()
 *             .name("example")
 *             .restApi(exampleAwsApiGatewayRestApi.id())
 *             .validateRequestBody(true)
 *             .validateRequestParameters(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apigateway:RequestValidator
 *     properties:
 *       name: example
 *       restApi: ${exampleAwsApiGatewayRestApi.id}
 *       validateRequestBody: true
 *       validateRequestParameters: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_request_validator` using `REST-API-ID/REQUEST-VALIDATOR-ID`. For example:
 * ```sh
 * $ pulumi import aws:apigateway/requestValidator:RequestValidator example 12345abcde/67890fghij
 * ```
 * @property name Name of the request validator
 * @property restApi ID of the associated Rest API
 * @property validateRequestBody Boolean whether to validate request body. Defaults to `false`.
 * @property validateRequestParameters Boolean whether to validate request parameters. Defaults to `false`.
 */
public data class RequestValidatorArgs(
    public val name: Output<String>? = null,
    public val restApi: Output<String>? = null,
    public val validateRequestBody: Output<Boolean>? = null,
    public val validateRequestParameters: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.RequestValidatorArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.RequestValidatorArgs =
        com.pulumi.aws.apigateway.RequestValidatorArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .restApi(restApi?.applyValue({ args0 -> args0 }))
            .validateRequestBody(validateRequestBody?.applyValue({ args0 -> args0 }))
            .validateRequestParameters(validateRequestParameters?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RequestValidatorArgs].
 */
@PulumiTagMarker
public class RequestValidatorArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var restApi: Output<String>? = null

    private var validateRequestBody: Output<Boolean>? = null

    private var validateRequestParameters: Output<Boolean>? = null

    /**
     * @param value Name of the request validator
     */
    @JvmName("fairbpkmpqkypwwr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value ID of the associated Rest API
     */
    @JvmName("fqpltgffuiafknpd")
    public suspend fun restApi(`value`: Output<String>) {
        this.restApi = value
    }

    /**
     * @param value Boolean whether to validate request body. Defaults to `false`.
     */
    @JvmName("supvytwxgcqsnwxn")
    public suspend fun validateRequestBody(`value`: Output<Boolean>) {
        this.validateRequestBody = value
    }

    /**
     * @param value Boolean whether to validate request parameters. Defaults to `false`.
     */
    @JvmName("ldbsljdtdgqevusb")
    public suspend fun validateRequestParameters(`value`: Output<Boolean>) {
        this.validateRequestParameters = value
    }

    /**
     * @param value Name of the request validator
     */
    @JvmName("mvgxcfleorjftcgx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value ID of the associated Rest API
     */
    @JvmName("ekvlsfrlcxftxuua")
    public suspend fun restApi(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restApi = mapped
    }

    /**
     * @param value Boolean whether to validate request body. Defaults to `false`.
     */
    @JvmName("kykobwkjbdlacnmf")
    public suspend fun validateRequestBody(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validateRequestBody = mapped
    }

    /**
     * @param value Boolean whether to validate request parameters. Defaults to `false`.
     */
    @JvmName("jiolelwveevpilra")
    public suspend fun validateRequestParameters(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validateRequestParameters = mapped
    }

    internal fun build(): RequestValidatorArgs = RequestValidatorArgs(
        name = name,
        restApi = restApi,
        validateRequestBody = validateRequestBody,
        validateRequestParameters = validateRequestParameters,
    )
}
