@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Resource].
 */
@PulumiTagMarker
public class ResourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceArgs = ResourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceArgsBuilder.() -> Unit) {
        val builder = ResourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Resource {
        val builtJavaResource = com.pulumi.aws.apigateway.Resource(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Resource(builtJavaResource)
    }
}

/**
 * Provides an API Gateway Resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const myDemoAPI = new aws.apigateway.RestApi("MyDemoAPI", {
 *     name: "MyDemoAPI",
 *     description: "This is my API for demonstration purposes",
 * });
 * const myDemoResource = new aws.apigateway.Resource("MyDemoResource", {
 *     restApi: myDemoAPI.id,
 *     parentId: myDemoAPI.rootResourceId,
 *     pathPart: "mydemoresource",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * my_demo_api = aws.apigateway.RestApi("MyDemoAPI",
 *     name="MyDemoAPI",
 *     description="This is my API for demonstration purposes")
 * my_demo_resource = aws.apigateway.Resource("MyDemoResource",
 *     rest_api=my_demo_api.id,
 *     parent_id=my_demo_api.root_resource_id,
 *     path_part="mydemoresource")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var myDemoAPI = new Aws.ApiGateway.RestApi("MyDemoAPI", new()
 *     {
 *         Name = "MyDemoAPI",
 *         Description = "This is my API for demonstration purposes",
 *     });
 *     var myDemoResource = new Aws.ApiGateway.Resource("MyDemoResource", new()
 *     {
 *         RestApi = myDemoAPI.Id,
 *         ParentId = myDemoAPI.RootResourceId,
 *         PathPart = "mydemoresource",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		myDemoAPI, err := apigateway.NewRestApi(ctx, "MyDemoAPI", &apigateway.RestApiArgs{
 * 			Name:        pulumi.String("MyDemoAPI"),
 * 			Description: pulumi.String("This is my API for demonstration purposes"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigateway.NewResource(ctx, "MyDemoResource", &apigateway.ResourceArgs{
 * 			RestApi:  myDemoAPI.ID(),
 * 			ParentId: myDemoAPI.RootResourceId,
 * 			PathPart: pulumi.String("mydemoresource"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Resource;
 * import com.pulumi.aws.apigateway.ResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myDemoAPI = new RestApi("myDemoAPI", RestApiArgs.builder()
 *             .name("MyDemoAPI")
 *             .description("This is my API for demonstration purposes")
 *             .build());
 *         var myDemoResource = new Resource("myDemoResource", ResourceArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .parentId(myDemoAPI.rootResourceId())
 *             .pathPart("mydemoresource")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   myDemoAPI:
 *     type: aws:apigateway:RestApi
 *     name: MyDemoAPI
 *     properties:
 *       name: MyDemoAPI
 *       description: This is my API for demonstration purposes
 *   myDemoResource:
 *     type: aws:apigateway:Resource
 *     name: MyDemoResource
 *     properties:
 *       restApi: ${myDemoAPI.id}
 *       parentId: ${myDemoAPI.rootResourceId}
 *       pathPart: mydemoresource
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_resource` using `REST-API-ID/RESOURCE-ID`. For example:
 * ```sh
 * $ pulumi import aws:apigateway/resource:Resource example 12345abcde/67890fghij
 * ```
 */
public class Resource internal constructor(
    override val javaResource: com.pulumi.aws.apigateway.Resource,
) : KotlinCustomResource(javaResource, ResourceMapper) {
    /**
     * ID of the parent API resource
     */
    public val parentId: Output<String>
        get() = javaResource.parentId().applyValue({ args0 -> args0 })

    /**
     * Complete path for this API resource, including all parent paths.
     */
    public val path: Output<String>
        get() = javaResource.path().applyValue({ args0 -> args0 })

    /**
     * Last path segment of this API resource.
     */
    public val pathPart: Output<String>
        get() = javaResource.pathPart().applyValue({ args0 -> args0 })

    /**
     * ID of the associated REST API
     */
    public val restApi: Output<String>
        get() = javaResource.restApi().applyValue({ args0 -> args0 })
}

public object ResourceMapper : ResourceMapper<Resource> {
    override fun supportsMappingOfType(javaResource: com.pulumi.resources.Resource): Boolean =
        com.pulumi.aws.apigateway.Resource::class == javaResource::class

    override fun map(javaResource: com.pulumi.resources.Resource): Resource = Resource(
        javaResource as
            com.pulumi.aws.apigateway.Resource,
    )
}

/**
 * @see [Resource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Resource].
 */
public suspend fun resource(name: String, block: suspend ResourceResourceBuilder.() -> Unit): Resource {
    val builder = ResourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Resource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resource(name: String): Resource {
    val builder = ResourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
