@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.ResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an API Gateway Resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const myDemoAPI = new aws.apigateway.RestApi("MyDemoAPI", {
 *     name: "MyDemoAPI",
 *     description: "This is my API for demonstration purposes",
 * });
 * const myDemoResource = new aws.apigateway.Resource("MyDemoResource", {
 *     restApi: myDemoAPI.id,
 *     parentId: myDemoAPI.rootResourceId,
 *     pathPart: "mydemoresource",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * my_demo_api = aws.apigateway.RestApi("MyDemoAPI",
 *     name="MyDemoAPI",
 *     description="This is my API for demonstration purposes")
 * my_demo_resource = aws.apigateway.Resource("MyDemoResource",
 *     rest_api=my_demo_api.id,
 *     parent_id=my_demo_api.root_resource_id,
 *     path_part="mydemoresource")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var myDemoAPI = new Aws.ApiGateway.RestApi("MyDemoAPI", new()
 *     {
 *         Name = "MyDemoAPI",
 *         Description = "This is my API for demonstration purposes",
 *     });
 *     var myDemoResource = new Aws.ApiGateway.Resource("MyDemoResource", new()
 *     {
 *         RestApi = myDemoAPI.Id,
 *         ParentId = myDemoAPI.RootResourceId,
 *         PathPart = "mydemoresource",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		myDemoAPI, err := apigateway.NewRestApi(ctx, "MyDemoAPI", &apigateway.RestApiArgs{
 * 			Name:        pulumi.String("MyDemoAPI"),
 * 			Description: pulumi.String("This is my API for demonstration purposes"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigateway.NewResource(ctx, "MyDemoResource", &apigateway.ResourceArgs{
 * 			RestApi:  myDemoAPI.ID(),
 * 			ParentId: myDemoAPI.RootResourceId,
 * 			PathPart: pulumi.String("mydemoresource"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Resource;
 * import com.pulumi.aws.apigateway.ResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myDemoAPI = new RestApi("myDemoAPI", RestApiArgs.builder()
 *             .name("MyDemoAPI")
 *             .description("This is my API for demonstration purposes")
 *             .build());
 *         var myDemoResource = new Resource("myDemoResource", ResourceArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .parentId(myDemoAPI.rootResourceId())
 *             .pathPart("mydemoresource")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   myDemoAPI:
 *     type: aws:apigateway:RestApi
 *     name: MyDemoAPI
 *     properties:
 *       name: MyDemoAPI
 *       description: This is my API for demonstration purposes
 *   myDemoResource:
 *     type: aws:apigateway:Resource
 *     name: MyDemoResource
 *     properties:
 *       restApi: ${myDemoAPI.id}
 *       parentId: ${myDemoAPI.rootResourceId}
 *       pathPart: mydemoresource
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_resource` using `REST-API-ID/RESOURCE-ID`. For example:
 * ```sh
 * $ pulumi import aws:apigateway/resource:Resource example 12345abcde/67890fghij
 * ```
 * @property parentId ID of the parent API resource
 * @property pathPart Last path segment of this API resource.
 * @property restApi ID of the associated REST API
 */
public data class ResourceArgs(
    public val parentId: Output<String>? = null,
    public val pathPart: Output<String>? = null,
    public val restApi: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.ResourceArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.ResourceArgs =
        com.pulumi.aws.apigateway.ResourceArgs.builder()
            .parentId(parentId?.applyValue({ args0 -> args0 }))
            .pathPart(pathPart?.applyValue({ args0 -> args0 }))
            .restApi(restApi?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceArgs].
 */
@PulumiTagMarker
public class ResourceArgsBuilder internal constructor() {
    private var parentId: Output<String>? = null

    private var pathPart: Output<String>? = null

    private var restApi: Output<String>? = null

    /**
     * @param value ID of the parent API resource
     */
    @JvmName("xmlvysthqheqpfwx")
    public suspend fun parentId(`value`: Output<String>) {
        this.parentId = value
    }

    /**
     * @param value Last path segment of this API resource.
     */
    @JvmName("xsfudgijpnuampfa")
    public suspend fun pathPart(`value`: Output<String>) {
        this.pathPart = value
    }

    /**
     * @param value ID of the associated REST API
     */
    @JvmName("qxlbskhcgwmtpggj")
    public suspend fun restApi(`value`: Output<String>) {
        this.restApi = value
    }

    /**
     * @param value ID of the parent API resource
     */
    @JvmName("sdentwqugkbfmpog")
    public suspend fun parentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentId = mapped
    }

    /**
     * @param value Last path segment of this API resource.
     */
    @JvmName("ifhtvbknbwhfvqin")
    public suspend fun pathPart(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pathPart = mapped
    }

    /**
     * @param value ID of the associated REST API
     */
    @JvmName("xhwrvnldmgvklhoh")
    public suspend fun restApi(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restApi = mapped
    }

    internal fun build(): ResourceArgs = ResourceArgs(
        parentId = parentId,
        pathPart = pathPart,
        restApi = restApi,
    )
}
