@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.ResponseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an API Gateway Gateway Response for a REST API Gateway.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.apigateway.RestApi("main", {name: "MyDemoAPI"});
 * const test = new aws.apigateway.Response("test", {
 *     restApiId: main.id,
 *     statusCode: "401",
 *     responseType: "UNAUTHORIZED",
 *     responseTemplates: {
 *         "application/json": "{\"message\":$context.error.messageString}",
 *     },
 *     responseParameters: {
 *         "gatewayresponse.header.Authorization": "'Basic'",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.apigateway.RestApi("main", name="MyDemoAPI")
 * test = aws.apigateway.Response("test",
 *     rest_api_id=main.id,
 *     status_code="401",
 *     response_type="UNAUTHORIZED",
 *     response_templates={
 *         "application/json": "{\"message\":$context.error.messageString}",
 *     },
 *     response_parameters={
 *         "gatewayresponse.header.Authorization": "'Basic'",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.ApiGateway.RestApi("main", new()
 *     {
 *         Name = "MyDemoAPI",
 *     });
 *     var test = new Aws.ApiGateway.Response("test", new()
 *     {
 *         RestApiId = main.Id,
 *         StatusCode = "401",
 *         ResponseType = "UNAUTHORIZED",
 *         ResponseTemplates =
 *         {
 *             { "application/json", "{\"message\":$context.error.messageString}" },
 *         },
 *         ResponseParameters =
 *         {
 *             { "gatewayresponse.header.Authorization", "'Basic'" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		main, err := apigateway.NewRestApi(ctx, "main", &apigateway.RestApiArgs{
 * 			Name: pulumi.String("MyDemoAPI"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigateway.NewResponse(ctx, "test", &apigateway.ResponseArgs{
 * 			RestApiId:    main.ID(),
 * 			StatusCode:   pulumi.String("401"),
 * 			ResponseType: pulumi.String("UNAUTHORIZED"),
 * 			ResponseTemplates: pulumi.StringMap{
 * 				"application/json": pulumi.String("{\"message\":$context.error.messageString}"),
 * 			},
 * 			ResponseParameters: pulumi.StringMap{
 * 				"gatewayresponse.header.Authorization": pulumi.String("'Basic'"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Response;
 * import com.pulumi.aws.apigateway.ResponseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new RestApi("main", RestApiArgs.builder()
 *             .name("MyDemoAPI")
 *             .build());
 *         var test = new Response("test", ResponseArgs.builder()
 *             .restApiId(main.id())
 *             .statusCode("401")
 *             .responseType("UNAUTHORIZED")
 *             .responseTemplates(Map.of("application/json", "{\"message\":$context.error.messageString}"))
 *             .responseParameters(Map.of("gatewayresponse.header.Authorization", "'Basic'"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:apigateway:RestApi
 *     properties:
 *       name: MyDemoAPI
 *   test:
 *     type: aws:apigateway:Response
 *     properties:
 *       restApiId: ${main.id}
 *       statusCode: '401'
 *       responseType: UNAUTHORIZED
 *       responseTemplates:
 *         application/json: '{"message":$context.error.messageString}'
 *       responseParameters:
 *         gatewayresponse.header.Authorization: '''Basic'''
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_gateway_response` using `REST-API-ID/RESPONSE-TYPE`. For example:
 * ```sh
 * $ pulumi import aws:apigateway/response:Response example 12345abcde/UNAUTHORIZED
 * ```
 * @property responseParameters Map of parameters (paths, query strings and headers) of the Gateway Response.
 * @property responseTemplates Map of templates used to transform the response body.
 * @property responseType Response type of the associated GatewayResponse.
 * @property restApiId String identifier of the associated REST API.
 * @property statusCode HTTP status code of the Gateway Response.
 */
public data class ResponseArgs(
    public val responseParameters: Output<Map<String, String>>? = null,
    public val responseTemplates: Output<Map<String, String>>? = null,
    public val responseType: Output<String>? = null,
    public val restApiId: Output<String>? = null,
    public val statusCode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.ResponseArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.ResponseArgs =
        com.pulumi.aws.apigateway.ResponseArgs.builder()
            .responseParameters(
                responseParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .responseTemplates(
                responseTemplates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .responseType(responseType?.applyValue({ args0 -> args0 }))
            .restApiId(restApiId?.applyValue({ args0 -> args0 }))
            .statusCode(statusCode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResponseArgs].
 */
@PulumiTagMarker
public class ResponseArgsBuilder internal constructor() {
    private var responseParameters: Output<Map<String, String>>? = null

    private var responseTemplates: Output<Map<String, String>>? = null

    private var responseType: Output<String>? = null

    private var restApiId: Output<String>? = null

    private var statusCode: Output<String>? = null

    /**
     * @param value Map of parameters (paths, query strings and headers) of the Gateway Response.
     */
    @JvmName("exnxnsttlibqokiy")
    public suspend fun responseParameters(`value`: Output<Map<String, String>>) {
        this.responseParameters = value
    }

    /**
     * @param value Map of templates used to transform the response body.
     */
    @JvmName("veafoytvrcsmybrm")
    public suspend fun responseTemplates(`value`: Output<Map<String, String>>) {
        this.responseTemplates = value
    }

    /**
     * @param value Response type of the associated GatewayResponse.
     */
    @JvmName("fmcimpepisfimdlw")
    public suspend fun responseType(`value`: Output<String>) {
        this.responseType = value
    }

    /**
     * @param value String identifier of the associated REST API.
     */
    @JvmName("fvqqnubbbpffuict")
    public suspend fun restApiId(`value`: Output<String>) {
        this.restApiId = value
    }

    /**
     * @param value HTTP status code of the Gateway Response.
     */
    @JvmName("bcgmvxfdtbkxhcii")
    public suspend fun statusCode(`value`: Output<String>) {
        this.statusCode = value
    }

    /**
     * @param value Map of parameters (paths, query strings and headers) of the Gateway Response.
     */
    @JvmName("xbmmlcratatpigrs")
    public suspend fun responseParameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseParameters = mapped
    }

    /**
     * @param values Map of parameters (paths, query strings and headers) of the Gateway Response.
     */
    @JvmName("twvntmoeccgikmox")
    public fun responseParameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responseParameters = mapped
    }

    /**
     * @param value Map of templates used to transform the response body.
     */
    @JvmName("jgtwrufwdwboxiwp")
    public suspend fun responseTemplates(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseTemplates = mapped
    }

    /**
     * @param values Map of templates used to transform the response body.
     */
    @JvmName("hpesgeqhbiesqtgs")
    public fun responseTemplates(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responseTemplates = mapped
    }

    /**
     * @param value Response type of the associated GatewayResponse.
     */
    @JvmName("kxjjpwtbphytgkcj")
    public suspend fun responseType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseType = mapped
    }

    /**
     * @param value String identifier of the associated REST API.
     */
    @JvmName("gkksfncuwsabkisv")
    public suspend fun restApiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restApiId = mapped
    }

    /**
     * @param value HTTP status code of the Gateway Response.
     */
    @JvmName("wmrwasrpkaotrtvf")
    public suspend fun statusCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statusCode = mapped
    }

    internal fun build(): ResponseArgs = ResponseArgs(
        responseParameters = responseParameters,
        responseTemplates = responseTemplates,
        responseType = responseType,
        restApiId = restApiId,
        statusCode = statusCode,
    )
}
