@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.RestApiPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an API Gateway REST API Policy.
 * > **Note:** Amazon API Gateway Version 1 resources are used for creating and deploying REST APIs. To create and deploy WebSocket and HTTP APIs, use Amazon API Gateway Version 2 resources.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testRestApi = new aws.apigateway.RestApi("test", {name: "example-rest-api"});
 * const test = aws.iam.getPolicyDocumentOutput({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "AWS",
 *             identifiers: ["*"],
 *         }],
 *         actions: ["execute-api:Invoke"],
 *         resources: [testRestApi&#46;executionArn],
 *         conditions: [{
 *             test: "IpAddress",
 *             variable: "aws:SourceIp",
 *             values: ["123&#46;123&#46;123&#46;123/32"],
 *         }],
 *     }],
 * });
 * const testRestApiPolicy = new aws.apigateway.RestApiPolicy("test", {
 *     restApiId: testRestApi.id,
 *     policy: test.apply(test => test.json),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_rest_api = aws.apigateway.RestApi("test", name="example-rest-api")
 * test = aws.iam.get_policy_document_output(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "AWS",
 *         "identifiers": ["*"],
 *     }],
 *     "actions": ["execute-api:Invoke"],
 *     "resources": [test_rest_api&#46;execution_arn],
 *     "conditions": [{
 *         "test": "IpAddress",
 *         "variable": "aws:SourceIp",
 *         "values": ["123&#46;123&#46;123&#46;123/32"],
 *     }],
 * }])
 * test_rest_api_policy = aws.apigateway.RestApiPolicy("test",
 *     rest_api_id=test_rest_api.id,
 *     policy=test.json)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testRestApi = new Aws.ApiGateway.RestApi("test", new()
 *     {
 *         Name = "example-rest-api",
 *     });
 *     var test = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             "*",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "execute-api:Invoke",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     testRestApi.ExecutionArn,
 *                 },
 *                 Conditions = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "IpAddress",
 *                         Variable = "aws:SourceIp",
 *                         Values = new[]
 *                         {
 *                             "123.123.123.123/32",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var testRestApiPolicy = new Aws.ApiGateway.RestApiPolicy("test", new()
 *     {
 *         RestApiId = testRestApi.Id,
 *         Policy = test.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		testRestApi, err := apigateway.NewRestApi(ctx, "test", &apigateway.RestApiArgs{
 * 			Name: pulumi.String("example-rest-api"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		test := iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * 			Statements: iam.GetPolicyDocumentStatementArray{
 * 				&iam.GetPolicyDocumentStatementArgs{
 * 					Effect: pulumi.String("Allow"),
 * 					Principals: iam.GetPolicyDocumentStatementPrincipalArray{
 * 						&iam.GetPolicyDocumentStatementPrincipalArgs{
 * 							Type: pulumi.String("AWS"),
 * 							Identifiers: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 						},
 * 					},
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("execute-api:Invoke"),
 * 					},
 * 					Resources: pulumi.StringArray{
 * 						testRestApi.ExecutionArn,
 * 					},
 * 					Conditions: iam.GetPolicyDocumentStatementConditionArray{
 * 						&iam.GetPolicyDocumentStatementConditionArgs{
 * 							Test:     pulumi.String("IpAddress"),
 * 							Variable: pulumi.String("aws:SourceIp"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("123.123.123.123/32"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		_, err = apigateway.NewRestApiPolicy(ctx, "test", &apigateway.RestApiPolicyArgs{
 * 			RestApiId: testRestApi.ID(),
 * 			Policy: pulumi.String(test.ApplyT(func(test iam.GetPolicyDocumentResult) (*string, error) {
 * 				return &test.Json, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.apigateway.RestApiPolicy;
 * import com.pulumi.aws.apigateway.RestApiPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testRestApi = new RestApi("testRestApi", RestApiArgs.builder()
 *             .name("example-rest-api")
 *             .build());
 *         final var test = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions("execute-api:Invoke")
 *                 .resources(testRestApi.executionArn())
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("IpAddress")
 *                     .variable("aws:SourceIp")
 *                     .values("123.123.123.123/32")
 *                     .build())
 *                 .build())
 *             .build());
 *         var testRestApiPolicy = new RestApiPolicy("testRestApiPolicy", RestApiPolicyArgs.builder()
 *             .restApiId(testRestApi.id())
 *             .policy(test.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(test -> test.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testRestApi:
 *     type: aws:apigateway:RestApi
 *     name: test
 *     properties:
 *       name: example-rest-api
 *   testRestApiPolicy:
 *     type: aws:apigateway:RestApiPolicy
 *     name: test
 *     properties:
 *       restApiId: ${testRestApi.id}
 *       policy: ${test.json}
 * variables:
 *   test:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - '*'
 *             actions:
 *               - execute-api:Invoke
 *             resources:
 *               - ${testRestApi.executionArn}
 *             conditions:
 *               - test: IpAddress
 *                 variable: aws:SourceIp
 *                 values:
 *                   - 123.123.123.123/32
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_rest_api_policy` using the REST API ID. For example:
 * ```sh
 * $ pulumi import aws:apigateway/restApiPolicy:RestApiPolicy example 12345abcde
 * ```
 * @property policy JSON formatted policy document that controls access to the API Gateway.
 * @property restApiId ID of the REST API.
 */
public data class RestApiPolicyArgs(
    public val policy: Output<String>? = null,
    public val restApiId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.RestApiPolicyArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.RestApiPolicyArgs =
        com.pulumi.aws.apigateway.RestApiPolicyArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0 }))
            .restApiId(restApiId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RestApiPolicyArgs].
 */
@PulumiTagMarker
public class RestApiPolicyArgsBuilder internal constructor() {
    private var policy: Output<String>? = null

    private var restApiId: Output<String>? = null

    /**
     * @param value JSON formatted policy document that controls access to the API Gateway.
     */
    @JvmName("lhxfwueoxpjsxrpg")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value ID of the REST API.
     */
    @JvmName("cqdxyjbeyhpsxequ")
    public suspend fun restApiId(`value`: Output<String>) {
        this.restApiId = value
    }

    /**
     * @param value JSON formatted policy document that controls access to the API Gateway.
     */
    @JvmName("qqhwwwixyuammoay")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value ID of the REST API.
     */
    @JvmName("xerpdkevyuwxbetj")
    public suspend fun restApiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restApiId = mapped
    }

    internal fun build(): RestApiPolicyArgs = RestApiPolicyArgs(
        policy = policy,
        restApiId = restApiId,
    )
}
