@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.kotlin.outputs.StageAccessLogSettings
import com.pulumi.aws.apigateway.kotlin.outputs.StageCanarySettings
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.apigateway.kotlin.outputs.StageAccessLogSettings.Companion.toKotlin as stageAccessLogSettingsToKotlin
import com.pulumi.aws.apigateway.kotlin.outputs.StageCanarySettings.Companion.toKotlin as stageCanarySettingsToKotlin

/**
 * Builder for [Stage].
 */
@PulumiTagMarker
public class StageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StageArgs = StageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StageArgsBuilder.() -> Unit) {
        val builder = StageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Stage {
        val builtJavaResource = com.pulumi.aws.apigateway.Stage(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Stage(builtJavaResource)
    }
}

/**
 * Manages an API Gateway Stage. A stage is a named reference to a deployment, which can be done via the `aws.apigateway.Deployment` resource. Stages can be optionally managed further with the `aws.apigateway.BasePathMapping` resource, `aws.apigateway.DomainName` resource, and `aws_api_method_settings` resource. For more information, see the [API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-stages.html).
 * ### Managing the API Logging CloudWatch Log Group
 * API Gateway provides the ability to [enable CloudWatch API logging](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html). To manage the CloudWatch Log Group when this feature is enabled, the `aws.cloudwatch.LogGroup` resource can be used where the name matches the API Gateway naming convention. If the CloudWatch Log Group previously exists, import the `aws.cloudwatch.LogGroup` resource into Pulumi as a one time operation. You can recreate the environment without import.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const config = new pulumi.Config();
 * const stageName = config.get("stageName") || "example";
 * const example = new aws.apigateway.RestApi("example", {});
 * const exampleLogGroup = new aws.cloudwatch.LogGroup("example", {
 *     name: pulumi.interpolate`API-Gateway-Execution-Logs_${example.id}/${stageName}`,
 *     retentionInDays: 7,
 * });
 * const exampleStage = new aws.apigateway.Stage("example", {stageName: stageName}, {
 *     dependsOn: [exampleLogGroup],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * config = pulumi.Config()
 * stage_name = config.get("stageName")
 * if stage_name is None:
 *     stage_name = "example"
 * example = aws.apigateway.RestApi("example")
 * example_log_group = aws.cloudwatch.LogGroup("example",
 *     name=example.id.apply(lambda id: f"API-Gateway-Execution-Logs_{id}/{stage_name}"),
 *     retention_in_days=7)
 * example_stage = aws.apigateway.Stage("example", stage_name=stage_name,
 * opts = pulumi.ResourceOptions(depends_on=[example_log_group]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var stageName = config.Get("stageName") ?? "example";
 *     var example = new Aws.ApiGateway.RestApi("example");
 *     var exampleLogGroup = new Aws.CloudWatch.LogGroup("example", new()
 *     {
 *         Name = example.Id.Apply(id => $"API-Gateway-Execution-Logs_{id}/{stageName}"),
 *         RetentionInDays = 7,
 *     });
 *     var exampleStage = new Aws.ApiGateway.Stage("example", new()
 *     {
 *         StageName = stageName,
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleLogGroup,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		stageName := "example"
 * 		if param := cfg.Get("stageName"); param != "" {
 * 			stageName = param
 * 		}
 * 		example, err := apigateway.NewRestApi(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleLogGroup, err := cloudwatch.NewLogGroup(ctx, "example", &cloudwatch.LogGroupArgs{
 * 			Name: example.ID().ApplyT(func(id string) (string, error) {
 * 				return fmt.Sprintf("API-Gateway-Execution-Logs_%v/%v", id, stageName), nil
 * 			}).(pulumi.StringOutput),
 * 			RetentionInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigateway.NewStage(ctx, "example", &apigateway.StageArgs{
 * 			StageName: pulumi.String(stageName),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleLogGroup,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.apigateway.Stage;
 * import com.pulumi.aws.apigateway.StageArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var stageName = config.get("stageName").orElse("example");
 *         var example = new RestApi("example");
 *         var exampleLogGroup = new LogGroup("exampleLogGroup", LogGroupArgs.builder()
 *             .name(example.id().applyValue(id -> String.format("API-Gateway-Execution-Logs_%s/%s", id,stageName)))
 *             .retentionInDays(7)
 *             .build());
 *         var exampleStage = new Stage("exampleStage", StageArgs.builder()
 *             .stageName(stageName)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleLogGroup)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   stageName:
 *     type: string
 *     default: example
 * resources:
 *   example:
 *     type: aws:apigateway:RestApi
 *   exampleStage:
 *     type: aws:apigateway:Stage
 *     name: example
 *     properties:
 *       stageName: ${stageName}
 *     options:
 *       dependson:
 *         - ${exampleLogGroup}
 *   exampleLogGroup:
 *     type: aws:cloudwatch:LogGroup
 *     name: example
 *     properties:
 *       name: API-Gateway-Execution-Logs_${example.id}/${stageName}
 *       retentionInDays: 7 # ... potentially other configuration ...
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_stage` using `REST-API-ID/STAGE-NAME`. For example:
 * ```sh
 * $ pulumi import aws:apigateway/stage:Stage example 12345abcde/example
 * ```
 */
public class Stage internal constructor(
    override val javaResource: com.pulumi.aws.apigateway.Stage,
) : KotlinCustomResource(javaResource, StageMapper) {
    /**
     * Enables access logs for the API stage. See Access Log Settings below.
     */
    public val accessLogSettings: Output<StageAccessLogSettings>?
        get() = javaResource.accessLogSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> stageAccessLogSettingsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * ARN
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Whether a cache cluster is enabled for the stage
     */
    public val cacheClusterEnabled: Output<Boolean>?
        get() = javaResource.cacheClusterEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Size of the cache cluster for the stage, if enabled. Allowed values include `0.5`, `1.6`, `6.1`, `13.5`, `28.4`, `58.2`, `118` and `237`.
     */
    public val cacheClusterSize: Output<String>?
        get() = javaResource.cacheClusterSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration settings of a canary deployment. See Canary Settings below.
     */
    public val canarySettings: Output<StageCanarySettings>?
        get() = javaResource.canarySettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> stageCanarySettingsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Identifier of a client certificate for the stage.
     */
    public val clientCertificateId: Output<String>?
        get() = javaResource.clientCertificateId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ID of the deployment that the stage points to
     */
    public val deployment: Output<String>
        get() = javaResource.deployment().applyValue({ args0 -> args0 })

    /**
     * Description of the stage.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Version of the associated API documentation
     */
    public val documentationVersion: Output<String>?
        get() = javaResource.documentationVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Execution ARN to be used in `lambda_permission`'s `source_arn`
     * when allowing API Gateway to invoke a Lambda function,
     * e.g., `arn:aws:execute-api:eu-west-2:123456789012:z4675bid1j/prod`
     */
    public val executionArn: Output<String>
        get() = javaResource.executionArn().applyValue({ args0 -> args0 })

    /**
     * URL to invoke the API pointing to the stage,
     * e.g., `https://z4675bid1j.execute-api.eu-west-2.amazonaws.com/prod`
     */
    public val invokeUrl: Output<String>
        get() = javaResource.invokeUrl().applyValue({ args0 -> args0 })

    /**
     * ID of the associated REST API
     */
    public val restApi: Output<String>
        get() = javaResource.restApi().applyValue({ args0 -> args0 })

    /**
     * Name of the stage
     */
    public val stageName: Output<String>
        get() = javaResource.stageName().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Map that defines the stage variables
     */
    public val variables: Output<Map<String, String>>?
        get() = javaResource.variables().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * ARN of the WebAcl associated with the Stage.
     */
    public val webAclArn: Output<String>
        get() = javaResource.webAclArn().applyValue({ args0 -> args0 })

    /**
     * Whether active tracing with X-ray is enabled. Defaults to `false`.
     */
    public val xrayTracingEnabled: Output<Boolean>?
        get() = javaResource.xrayTracingEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object StageMapper : ResourceMapper<Stage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigateway.Stage::class == javaResource::class

    override fun map(javaResource: Resource): Stage = Stage(
        javaResource as
            com.pulumi.aws.apigateway.Stage,
    )
}

/**
 * @see [Stage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Stage].
 */
public suspend fun stage(name: String, block: suspend StageResourceBuilder.() -> Unit): Stage {
    val builder = StageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Stage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun stage(name: String): Stage {
    val builder = StageResourceBuilder()
    builder.name(name)
    return builder.build()
}
