@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.StageArgs.builder
import com.pulumi.aws.apigateway.kotlin.inputs.StageAccessLogSettingsArgs
import com.pulumi.aws.apigateway.kotlin.inputs.StageAccessLogSettingsArgsBuilder
import com.pulumi.aws.apigateway.kotlin.inputs.StageCanarySettingsArgs
import com.pulumi.aws.apigateway.kotlin.inputs.StageCanarySettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an API Gateway Stage. A stage is a named reference to a deployment, which can be done via the `aws.apigateway.Deployment` resource. Stages can be optionally managed further with the `aws.apigateway.BasePathMapping` resource, `aws.apigateway.DomainName` resource, and `aws_api_method_settings` resource. For more information, see the [API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-stages.html).
 * ### Managing the API Logging CloudWatch Log Group
 * API Gateway provides the ability to [enable CloudWatch API logging](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html). To manage the CloudWatch Log Group when this feature is enabled, the `aws.cloudwatch.LogGroup` resource can be used where the name matches the API Gateway naming convention. If the CloudWatch Log Group previously exists, import the `aws.cloudwatch.LogGroup` resource into Pulumi as a one time operation. You can recreate the environment without import.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const config = new pulumi.Config();
 * const stageName = config.get("stageName") || "example";
 * const example = new aws.apigateway.RestApi("example", {});
 * const exampleLogGroup = new aws.cloudwatch.LogGroup("example", {
 *     name: pulumi.interpolate`API-Gateway-Execution-Logs_${example.id}/${stageName}`,
 *     retentionInDays: 7,
 * });
 * const exampleStage = new aws.apigateway.Stage("example", {stageName: stageName}, {
 *     dependsOn: [exampleLogGroup],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * config = pulumi.Config()
 * stage_name = config.get("stageName")
 * if stage_name is None:
 *     stage_name = "example"
 * example = aws.apigateway.RestApi("example")
 * example_log_group = aws.cloudwatch.LogGroup("example",
 *     name=example.id.apply(lambda id: f"API-Gateway-Execution-Logs_{id}/{stage_name}"),
 *     retention_in_days=7)
 * example_stage = aws.apigateway.Stage("example", stage_name=stage_name,
 * opts = pulumi.ResourceOptions(depends_on=[example_log_group]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var stageName = config.Get("stageName") ?? "example";
 *     var example = new Aws.ApiGateway.RestApi("example");
 *     var exampleLogGroup = new Aws.CloudWatch.LogGroup("example", new()
 *     {
 *         Name = example.Id.Apply(id => $"API-Gateway-Execution-Logs_{id}/{stageName}"),
 *         RetentionInDays = 7,
 *     });
 *     var exampleStage = new Aws.ApiGateway.Stage("example", new()
 *     {
 *         StageName = stageName,
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleLogGroup,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		stageName := "example"
 * 		if param := cfg.Get("stageName"); param != "" {
 * 			stageName = param
 * 		}
 * 		example, err := apigateway.NewRestApi(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleLogGroup, err := cloudwatch.NewLogGroup(ctx, "example", &cloudwatch.LogGroupArgs{
 * 			Name: example.ID().ApplyT(func(id string) (string, error) {
 * 				return fmt.Sprintf("API-Gateway-Execution-Logs_%v/%v", id, stageName), nil
 * 			}).(pulumi.StringOutput),
 * 			RetentionInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigateway.NewStage(ctx, "example", &apigateway.StageArgs{
 * 			StageName: pulumi.String(stageName),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleLogGroup,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.apigateway.Stage;
 * import com.pulumi.aws.apigateway.StageArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var stageName = config.get("stageName").orElse("example");
 *         var example = new RestApi("example");
 *         var exampleLogGroup = new LogGroup("exampleLogGroup", LogGroupArgs.builder()
 *             .name(example.id().applyValue(id -> String.format("API-Gateway-Execution-Logs_%s/%s", id,stageName)))
 *             .retentionInDays(7)
 *             .build());
 *         var exampleStage = new Stage("exampleStage", StageArgs.builder()
 *             .stageName(stageName)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleLogGroup)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   stageName:
 *     type: string
 *     default: example
 * resources:
 *   example:
 *     type: aws:apigateway:RestApi
 *   exampleStage:
 *     type: aws:apigateway:Stage
 *     name: example
 *     properties:
 *       stageName: ${stageName}
 *     options:
 *       dependson:
 *         - ${exampleLogGroup}
 *   exampleLogGroup:
 *     type: aws:cloudwatch:LogGroup
 *     name: example
 *     properties:
 *       name: API-Gateway-Execution-Logs_${example.id}/${stageName}
 *       retentionInDays: 7 # ... potentially other configuration ...
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_stage` using `REST-API-ID/STAGE-NAME`. For example:
 * ```sh
 * $ pulumi import aws:apigateway/stage:Stage example 12345abcde/example
 * ```
 * @property accessLogSettings Enables access logs for the API stage. See Access Log Settings below.
 * @property cacheClusterEnabled Whether a cache cluster is enabled for the stage
 * @property cacheClusterSize Size of the cache cluster for the stage, if enabled. Allowed values include `0.5`, `1.6`, `6.1`, `13.5`, `28.4`, `58.2`, `118` and `237`.
 * @property canarySettings Configuration settings of a canary deployment. See Canary Settings below.
 * @property clientCertificateId Identifier of a client certificate for the stage.
 * @property deployment ID of the deployment that the stage points to
 * @property description Description of the stage.
 * @property documentationVersion Version of the associated API documentation
 * @property restApi ID of the associated REST API
 * @property stageName Name of the stage
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property variables Map that defines the stage variables
 * @property xrayTracingEnabled Whether active tracing with X-ray is enabled. Defaults to `false`.
 */
public data class StageArgs(
    public val accessLogSettings: Output<StageAccessLogSettingsArgs>? = null,
    public val cacheClusterEnabled: Output<Boolean>? = null,
    public val cacheClusterSize: Output<String>? = null,
    public val canarySettings: Output<StageCanarySettingsArgs>? = null,
    public val clientCertificateId: Output<String>? = null,
    public val deployment: Output<String>? = null,
    public val description: Output<String>? = null,
    public val documentationVersion: Output<String>? = null,
    public val restApi: Output<String>? = null,
    public val stageName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val variables: Output<Map<String, String>>? = null,
    public val xrayTracingEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.StageArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.StageArgs =
        com.pulumi.aws.apigateway.StageArgs.builder()
            .accessLogSettings(accessLogSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cacheClusterEnabled(cacheClusterEnabled?.applyValue({ args0 -> args0 }))
            .cacheClusterSize(cacheClusterSize?.applyValue({ args0 -> args0 }))
            .canarySettings(canarySettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .clientCertificateId(clientCertificateId?.applyValue({ args0 -> args0 }))
            .deployment(deployment?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .documentationVersion(documentationVersion?.applyValue({ args0 -> args0 }))
            .restApi(restApi?.applyValue({ args0 -> args0 }))
            .stageName(stageName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .variables(
                variables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .xrayTracingEnabled(xrayTracingEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StageArgs].
 */
@PulumiTagMarker
public class StageArgsBuilder internal constructor() {
    private var accessLogSettings: Output<StageAccessLogSettingsArgs>? = null

    private var cacheClusterEnabled: Output<Boolean>? = null

    private var cacheClusterSize: Output<String>? = null

    private var canarySettings: Output<StageCanarySettingsArgs>? = null

    private var clientCertificateId: Output<String>? = null

    private var deployment: Output<String>? = null

    private var description: Output<String>? = null

    private var documentationVersion: Output<String>? = null

    private var restApi: Output<String>? = null

    private var stageName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var variables: Output<Map<String, String>>? = null

    private var xrayTracingEnabled: Output<Boolean>? = null

    /**
     * @param value Enables access logs for the API stage. See Access Log Settings below.
     */
    @JvmName("ulobxghqenwldhge")
    public suspend fun accessLogSettings(`value`: Output<StageAccessLogSettingsArgs>) {
        this.accessLogSettings = value
    }

    /**
     * @param value Whether a cache cluster is enabled for the stage
     */
    @JvmName("vglngfjrveyvrflw")
    public suspend fun cacheClusterEnabled(`value`: Output<Boolean>) {
        this.cacheClusterEnabled = value
    }

    /**
     * @param value Size of the cache cluster for the stage, if enabled. Allowed values include `0.5`, `1.6`, `6.1`, `13.5`, `28.4`, `58.2`, `118` and `237`.
     */
    @JvmName("qqwtfpltxjalmlcy")
    public suspend fun cacheClusterSize(`value`: Output<String>) {
        this.cacheClusterSize = value
    }

    /**
     * @param value Configuration settings of a canary deployment. See Canary Settings below.
     */
    @JvmName("mowtgynqrctjerhg")
    public suspend fun canarySettings(`value`: Output<StageCanarySettingsArgs>) {
        this.canarySettings = value
    }

    /**
     * @param value Identifier of a client certificate for the stage.
     */
    @JvmName("qsclqkowvcanwkpb")
    public suspend fun clientCertificateId(`value`: Output<String>) {
        this.clientCertificateId = value
    }

    /**
     * @param value ID of the deployment that the stage points to
     */
    @JvmName("ovkvbtxgthvnpseg")
    public suspend fun deployment(`value`: Output<String>) {
        this.deployment = value
    }

    /**
     * @param value Description of the stage.
     */
    @JvmName("wybtgjbigpscvkvx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Version of the associated API documentation
     */
    @JvmName("pissrsxtwlvyybca")
    public suspend fun documentationVersion(`value`: Output<String>) {
        this.documentationVersion = value
    }

    /**
     * @param value ID of the associated REST API
     */
    @JvmName("hhmfarnbsmjblinu")
    public suspend fun restApi(`value`: Output<String>) {
        this.restApi = value
    }

    /**
     * @param value Name of the stage
     */
    @JvmName("ckowgqvaxprmnuok")
    public suspend fun stageName(`value`: Output<String>) {
        this.stageName = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gcxppjpwypuirshj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Map that defines the stage variables
     */
    @JvmName("xcknjxjcctclornj")
    public suspend fun variables(`value`: Output<Map<String, String>>) {
        this.variables = value
    }

    /**
     * @param value Whether active tracing with X-ray is enabled. Defaults to `false`.
     */
    @JvmName("nqmnpixkbibipfgr")
    public suspend fun xrayTracingEnabled(`value`: Output<Boolean>) {
        this.xrayTracingEnabled = value
    }

    /**
     * @param value Enables access logs for the API stage. See Access Log Settings below.
     */
    @JvmName("sqidsudckxlnnwuu")
    public suspend fun accessLogSettings(`value`: StageAccessLogSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLogSettings = mapped
    }

    /**
     * @param argument Enables access logs for the API stage. See Access Log Settings below.
     */
    @JvmName("hvdpwwmrexynfmjb")
    public suspend fun accessLogSettings(argument: suspend StageAccessLogSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = StageAccessLogSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessLogSettings = mapped
    }

    /**
     * @param value Whether a cache cluster is enabled for the stage
     */
    @JvmName("twyvrbrglcjmcriq")
    public suspend fun cacheClusterEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheClusterEnabled = mapped
    }

    /**
     * @param value Size of the cache cluster for the stage, if enabled. Allowed values include `0.5`, `1.6`, `6.1`, `13.5`, `28.4`, `58.2`, `118` and `237`.
     */
    @JvmName("tpuynfrdibdxxbvm")
    public suspend fun cacheClusterSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheClusterSize = mapped
    }

    /**
     * @param value Configuration settings of a canary deployment. See Canary Settings below.
     */
    @JvmName("ofwmjsfhrhyrujed")
    public suspend fun canarySettings(`value`: StageCanarySettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.canarySettings = mapped
    }

    /**
     * @param argument Configuration settings of a canary deployment. See Canary Settings below.
     */
    @JvmName("efdxlewtbwqotjav")
    public suspend fun canarySettings(argument: suspend StageCanarySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = StageCanarySettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.canarySettings = mapped
    }

    /**
     * @param value Identifier of a client certificate for the stage.
     */
    @JvmName("ccioaxwikpchcarh")
    public suspend fun clientCertificateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCertificateId = mapped
    }

    /**
     * @param value ID of the deployment that the stage points to
     */
    @JvmName("wdvwogguvbrmirli")
    public suspend fun deployment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deployment = mapped
    }

    /**
     * @param value Description of the stage.
     */
    @JvmName("whdmcpixtwmcpndp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Version of the associated API documentation
     */
    @JvmName("dpwqjupysvlsxgdx")
    public suspend fun documentationVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentationVersion = mapped
    }

    /**
     * @param value ID of the associated REST API
     */
    @JvmName("ekyaojactgnmiktx")
    public suspend fun restApi(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restApi = mapped
    }

    /**
     * @param value Name of the stage
     */
    @JvmName("mpjaijmornklesly")
    public suspend fun stageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stageName = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hoaqvotmblxhyjhc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pgeyjssvhpfwgrom")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Map that defines the stage variables
     */
    @JvmName("jewytawtqmkvwwpf")
    public suspend fun variables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variables = mapped
    }

    /**
     * @param values Map that defines the stage variables
     */
    @JvmName("fjmjjhpvgdigfrgq")
    public fun variables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variables = mapped
    }

    /**
     * @param value Whether active tracing with X-ray is enabled. Defaults to `false`.
     */
    @JvmName("gyrxhqdqrfhmgdef")
    public suspend fun xrayTracingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xrayTracingEnabled = mapped
    }

    internal fun build(): StageArgs = StageArgs(
        accessLogSettings = accessLogSettings,
        cacheClusterEnabled = cacheClusterEnabled,
        cacheClusterSize = cacheClusterSize,
        canarySettings = canarySettings,
        clientCertificateId = clientCertificateId,
        deployment = deployment,
        description = description,
        documentationVersion = documentationVersion,
        restApi = restApi,
        stageName = stageName,
        tags = tags,
        variables = variables,
        xrayTracingEnabled = xrayTracingEnabled,
    )
}
