@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.kotlin.outputs.UsagePlanApiStage
import com.pulumi.aws.apigateway.kotlin.outputs.UsagePlanQuotaSettings
import com.pulumi.aws.apigateway.kotlin.outputs.UsagePlanThrottleSettings
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.apigateway.kotlin.outputs.UsagePlanApiStage.Companion.toKotlin as usagePlanApiStageToKotlin
import com.pulumi.aws.apigateway.kotlin.outputs.UsagePlanQuotaSettings.Companion.toKotlin as usagePlanQuotaSettingsToKotlin
import com.pulumi.aws.apigateway.kotlin.outputs.UsagePlanThrottleSettings.Companion.toKotlin as usagePlanThrottleSettingsToKotlin

/**
 * Builder for [UsagePlan].
 */
@PulumiTagMarker
public class UsagePlanResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UsagePlanArgs = UsagePlanArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UsagePlanArgsBuilder.() -> Unit) {
        val builder = UsagePlanArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UsagePlan {
        val builtJavaResource = com.pulumi.aws.apigateway.UsagePlan(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UsagePlan(builtJavaResource)
    }
}

/**
 * Provides an API Gateway Usage Plan.
 * ## Import
 * Using `pulumi import`, import AWS API Gateway Usage Plan using the `id`. For example:
 * ```sh
 * $ pulumi import aws:apigateway/usagePlan:UsagePlan myusageplan <usage_plan_id>
 * ```
 */
public class UsagePlan internal constructor(
    override val javaResource: com.pulumi.aws.apigateway.UsagePlan,
) : KotlinCustomResource(javaResource, UsagePlanMapper) {
    /**
     * Associated API stages of the usage plan.
     */
    public val apiStages: Output<List<UsagePlanApiStage>>?
        get() = javaResource.apiStages().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> usagePlanApiStageToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * ARN
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of a usage plan.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the usage plan.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * AWS Marketplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.
     */
    public val productCode: Output<String>?
        get() = javaResource.productCode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Quota of the usage plan.
     */
    public val quotaSettings: Output<UsagePlanQuotaSettings>?
        get() = javaResource.quotaSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> usagePlanQuotaSettingsToKotlin(args0) })
            }).orElse(null)
        })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Throttling limits of the usage plan.
     */
    public val throttleSettings: Output<UsagePlanThrottleSettings>?
        get() = javaResource.throttleSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> usagePlanThrottleSettingsToKotlin(args0) })
            }).orElse(null)
        })
}

public object UsagePlanMapper : ResourceMapper<UsagePlan> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigateway.UsagePlan::class == javaResource::class

    override fun map(javaResource: Resource): UsagePlan = UsagePlan(
        javaResource as
            com.pulumi.aws.apigateway.UsagePlan,
    )
}

/**
 * @see [UsagePlan].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UsagePlan].
 */
public suspend fun usagePlan(name: String, block: suspend UsagePlanResourceBuilder.() -> Unit): UsagePlan {
    val builder = UsagePlanResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UsagePlan].
 * @param name The _unique_ name of the resulting resource.
 */
public fun usagePlan(name: String): UsagePlan {
    val builder = UsagePlanResourceBuilder()
    builder.name(name)
    return builder.build()
}
