@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.UsagePlanArgs.builder
import com.pulumi.aws.apigateway.kotlin.inputs.UsagePlanApiStageArgs
import com.pulumi.aws.apigateway.kotlin.inputs.UsagePlanApiStageArgsBuilder
import com.pulumi.aws.apigateway.kotlin.inputs.UsagePlanQuotaSettingsArgs
import com.pulumi.aws.apigateway.kotlin.inputs.UsagePlanQuotaSettingsArgsBuilder
import com.pulumi.aws.apigateway.kotlin.inputs.UsagePlanThrottleSettingsArgs
import com.pulumi.aws.apigateway.kotlin.inputs.UsagePlanThrottleSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an API Gateway Usage Plan.
 * ## Import
 * Using `pulumi import`, import AWS API Gateway Usage Plan using the `id`. For example:
 * ```sh
 * $ pulumi import aws:apigateway/usagePlan:UsagePlan myusageplan <usage_plan_id>
 * ```
 * @property apiStages Associated API stages of the usage plan.
 * @property description Description of a usage plan.
 * @property name Name of the usage plan.
 * @property productCode AWS Marketplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.
 * @property quotaSettings Quota of the usage plan.
 * @property tags
 * @property throttleSettings Throttling limits of the usage plan.
 */
public data class UsagePlanArgs(
    public val apiStages: Output<List<UsagePlanApiStageArgs>>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val productCode: Output<String>? = null,
    public val quotaSettings: Output<UsagePlanQuotaSettingsArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val throttleSettings: Output<UsagePlanThrottleSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.UsagePlanArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.UsagePlanArgs =
        com.pulumi.aws.apigateway.UsagePlanArgs.builder()
            .apiStages(
                apiStages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .productCode(productCode?.applyValue({ args0 -> args0 }))
            .quotaSettings(quotaSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .throttleSettings(
                throttleSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [UsagePlanArgs].
 */
@PulumiTagMarker
public class UsagePlanArgsBuilder internal constructor() {
    private var apiStages: Output<List<UsagePlanApiStageArgs>>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var productCode: Output<String>? = null

    private var quotaSettings: Output<UsagePlanQuotaSettingsArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var throttleSettings: Output<UsagePlanThrottleSettingsArgs>? = null

    /**
     * @param value Associated API stages of the usage plan.
     */
    @JvmName("kjgtastdwfifckfx")
    public suspend fun apiStages(`value`: Output<List<UsagePlanApiStageArgs>>) {
        this.apiStages = value
    }

    @JvmName("srftfqidvqdwgkcd")
    public suspend fun apiStages(vararg values: Output<UsagePlanApiStageArgs>) {
        this.apiStages = Output.all(values.asList())
    }

    /**
     * @param values Associated API stages of the usage plan.
     */
    @JvmName("luslduogexggouie")
    public suspend fun apiStages(values: List<Output<UsagePlanApiStageArgs>>) {
        this.apiStages = Output.all(values)
    }

    /**
     * @param value Description of a usage plan.
     */
    @JvmName("crjfonmbaynblpdf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the usage plan.
     */
    @JvmName("tamrpsaerhjwpqvr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value AWS Marketplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.
     */
    @JvmName("ykqmnybttxoovqay")
    public suspend fun productCode(`value`: Output<String>) {
        this.productCode = value
    }

    /**
     * @param value Quota of the usage plan.
     */
    @JvmName("tjrkdrpxewbpjiru")
    public suspend fun quotaSettings(`value`: Output<UsagePlanQuotaSettingsArgs>) {
        this.quotaSettings = value
    }

    /**
     * @param value
     */
    @JvmName("dfegkvpvtvyowako")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Throttling limits of the usage plan.
     */
    @JvmName("ybxuciwepcghkbdg")
    public suspend fun throttleSettings(`value`: Output<UsagePlanThrottleSettingsArgs>) {
        this.throttleSettings = value
    }

    /**
     * @param value Associated API stages of the usage plan.
     */
    @JvmName("ajmbckumfuahjmdw")
    public suspend fun apiStages(`value`: List<UsagePlanApiStageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiStages = mapped
    }

    /**
     * @param argument Associated API stages of the usage plan.
     */
    @JvmName("ayhrtfkxphmxyoys")
    public suspend fun apiStages(argument: List<suspend UsagePlanApiStageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UsagePlanApiStageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.apiStages = mapped
    }

    /**
     * @param argument Associated API stages of the usage plan.
     */
    @JvmName("igkbybawqujavfld")
    public suspend fun apiStages(vararg argument: suspend UsagePlanApiStageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UsagePlanApiStageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.apiStages = mapped
    }

    /**
     * @param argument Associated API stages of the usage plan.
     */
    @JvmName("utrvavfuabtxcjwt")
    public suspend fun apiStages(argument: suspend UsagePlanApiStageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UsagePlanApiStageArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.apiStages = mapped
    }

    /**
     * @param values Associated API stages of the usage plan.
     */
    @JvmName("itskpevnhsmepcco")
    public suspend fun apiStages(vararg values: UsagePlanApiStageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiStages = mapped
    }

    /**
     * @param value Description of a usage plan.
     */
    @JvmName("fncxvsojtlvkoetd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the usage plan.
     */
    @JvmName("xkxbfarnirfudvaf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value AWS Marketplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.
     */
    @JvmName("vdxevswjwqbmgwta")
    public suspend fun productCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productCode = mapped
    }

    /**
     * @param value Quota of the usage plan.
     */
    @JvmName("lcpjixagseysldhf")
    public suspend fun quotaSettings(`value`: UsagePlanQuotaSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quotaSettings = mapped
    }

    /**
     * @param argument Quota of the usage plan.
     */
    @JvmName("dkoovlsbmojxhrcs")
    public suspend fun quotaSettings(argument: suspend UsagePlanQuotaSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UsagePlanQuotaSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.quotaSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("mosgvpswahcflrib")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("pcgmqmatjpswfdtv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Throttling limits of the usage plan.
     */
    @JvmName("uvjpgusgsfnglawd")
    public suspend fun throttleSettings(`value`: UsagePlanThrottleSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttleSettings = mapped
    }

    /**
     * @param argument Throttling limits of the usage plan.
     */
    @JvmName("uapveovxyonfkbgu")
    public suspend fun throttleSettings(argument: suspend UsagePlanThrottleSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UsagePlanThrottleSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.throttleSettings = mapped
    }

    internal fun build(): UsagePlanArgs = UsagePlanArgs(
        apiStages = apiStages,
        description = description,
        name = name,
        productCode = productCode,
        quotaSettings = quotaSettings,
        tags = tags,
        throttleSettings = throttleSettings,
    )
}
