@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UsagePlanKey].
 */
@PulumiTagMarker
public class UsagePlanKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UsagePlanKeyArgs = UsagePlanKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UsagePlanKeyArgsBuilder.() -> Unit) {
        val builder = UsagePlanKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UsagePlanKey {
        val builtJavaResource = com.pulumi.aws.apigateway.UsagePlanKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UsagePlanKey(builtJavaResource)
    }
}

/**
 * Provides an API Gateway Usage Plan Key.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.apigateway.RestApi("test", {name: "MyDemoAPI"});
 * // ...
 * const myusageplan = new aws.apigateway.UsagePlan("myusageplan", {
 *     name: "my_usage_plan",
 *     apiStages: [{
 *         apiId: test.id,
 *         stage: foo.stageName,
 *     }],
 * });
 * const mykey = new aws.apigateway.ApiKey("mykey", {name: "my_key"});
 * const main = new aws.apigateway.UsagePlanKey("main", {
 *     keyId: mykey.id,
 *     keyType: "API_KEY",
 *     usagePlanId: myusageplan.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.apigateway.RestApi("test", name="MyDemoAPI")
 * # ...
 * myusageplan = aws.apigateway.UsagePlan("myusageplan",
 *     name="my_usage_plan",
 *     api_stages=[{
 *         "api_id": test.id,
 *         "stage": foo["stageName"],
 *     }])
 * mykey = aws.apigateway.ApiKey("mykey", name="my_key")
 * main = aws.apigateway.UsagePlanKey("main",
 *     key_id=mykey.id,
 *     key_type="API_KEY",
 *     usage_plan_id=myusageplan.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.ApiGateway.RestApi("test", new()
 *     {
 *         Name = "MyDemoAPI",
 *     });
 *     // ...
 *     var myusageplan = new Aws.ApiGateway.UsagePlan("myusageplan", new()
 *     {
 *         Name = "my_usage_plan",
 *         ApiStages = new[]
 *         {
 *             new Aws.ApiGateway.Inputs.UsagePlanApiStageArgs
 *             {
 *                 ApiId = test.Id,
 *                 Stage = foo.StageName,
 *             },
 *         },
 *     });
 *     var mykey = new Aws.ApiGateway.ApiKey("mykey", new()
 *     {
 *         Name = "my_key",
 *     });
 *     var main = new Aws.ApiGateway.UsagePlanKey("main", new()
 *     {
 *         KeyId = mykey.Id,
 *         KeyType = "API_KEY",
 *         UsagePlanId = myusageplan.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := apigateway.NewRestApi(ctx, "test", &apigateway.RestApiArgs{
 * 			Name: pulumi.String("MyDemoAPI"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// ...
 * 		myusageplan, err := apigateway.NewUsagePlan(ctx, "myusageplan", &apigateway.UsagePlanArgs{
 * 			Name: pulumi.String("my_usage_plan"),
 * 			ApiStages: apigateway.UsagePlanApiStageArray{
 * 				&apigateway.UsagePlanApiStageArgs{
 * 					ApiId: test.ID(),
 * 					Stage: pulumi.Any(foo.StageName),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		mykey, err := apigateway.NewApiKey(ctx, "mykey", &apigateway.ApiKeyArgs{
 * 			Name: pulumi.String("my_key"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigateway.NewUsagePlanKey(ctx, "main", &apigateway.UsagePlanKeyArgs{
 * 			KeyId:       mykey.ID(),
 * 			KeyType:     pulumi.String("API_KEY"),
 * 			UsagePlanId: myusageplan.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.UsagePlan;
 * import com.pulumi.aws.apigateway.UsagePlanArgs;
 * import com.pulumi.aws.apigateway.inputs.UsagePlanApiStageArgs;
 * import com.pulumi.aws.apigateway.ApiKey;
 * import com.pulumi.aws.apigateway.ApiKeyArgs;
 * import com.pulumi.aws.apigateway.UsagePlanKey;
 * import com.pulumi.aws.apigateway.UsagePlanKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new RestApi("test", RestApiArgs.builder()
 *             .name("MyDemoAPI")
 *             .build());
 *         // ...
 *         var myusageplan = new UsagePlan("myusageplan", UsagePlanArgs.builder()
 *             .name("my_usage_plan")
 *             .apiStages(UsagePlanApiStageArgs.builder()
 *                 .apiId(test.id())
 *                 .stage(foo.stageName())
 *                 .build())
 *             .build());
 *         var mykey = new ApiKey("mykey", ApiKeyArgs.builder()
 *             .name("my_key")
 *             .build());
 *         var main = new UsagePlanKey("main", UsagePlanKeyArgs.builder()
 *             .keyId(mykey.id())
 *             .keyType("API_KEY")
 *             .usagePlanId(myusageplan.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:apigateway:RestApi
 *     properties:
 *       name: MyDemoAPI
 *   # ...
 *   myusageplan:
 *     type: aws:apigateway:UsagePlan
 *     properties:
 *       name: my_usage_plan
 *       apiStages:
 *         - apiId: ${test.id}
 *           stage: ${foo.stageName}
 *   mykey:
 *     type: aws:apigateway:ApiKey
 *     properties:
 *       name: my_key
 *   main:
 *     type: aws:apigateway:UsagePlanKey
 *     properties:
 *       keyId: ${mykey.id}
 *       keyType: API_KEY
 *       usagePlanId: ${myusageplan.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AWS API Gateway Usage Plan Key using the `USAGE-PLAN-ID/USAGE-PLAN-KEY-ID`. For example:
 * ```sh
 * $ pulumi import aws:apigateway/usagePlanKey:UsagePlanKey key 12345abcde/zzz
 * ```
 */
public class UsagePlanKey internal constructor(
    override val javaResource: com.pulumi.aws.apigateway.UsagePlanKey,
) : KotlinCustomResource(javaResource, UsagePlanKeyMapper) {
    /**
     * Identifier of the API key resource.
     */
    public val keyId: Output<String>
        get() = javaResource.keyId().applyValue({ args0 -> args0 })

    /**
     * Type of the API key resource. Currently, the valid key type is API_KEY.
     */
    public val keyType: Output<String>
        get() = javaResource.keyType().applyValue({ args0 -> args0 })

    /**
     * Name of a usage plan key.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Id of the usage plan resource representing to associate the key to.
     */
    public val usagePlanId: Output<String>
        get() = javaResource.usagePlanId().applyValue({ args0 -> args0 })

    /**
     * Value of a usage plan key.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })
}

public object UsagePlanKeyMapper : ResourceMapper<UsagePlanKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigateway.UsagePlanKey::class == javaResource::class

    override fun map(javaResource: Resource): UsagePlanKey = UsagePlanKey(
        javaResource as
            com.pulumi.aws.apigateway.UsagePlanKey,
    )
}

/**
 * @see [UsagePlanKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UsagePlanKey].
 */
public suspend fun usagePlanKey(
    name: String,
    block: suspend UsagePlanKeyResourceBuilder.() -> Unit,
): UsagePlanKey {
    val builder = UsagePlanKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UsagePlanKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun usagePlanKey(name: String): UsagePlanKey {
    val builder = UsagePlanKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
