@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [VpcLink].
 */
@PulumiTagMarker
public class VpcLinkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcLinkArgs = VpcLinkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcLinkArgsBuilder.() -> Unit) {
        val builder = VpcLinkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpcLink {
        val builtJavaResource = com.pulumi.aws.apigateway.VpcLink(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcLink(builtJavaResource)
    }
}

/**
 * Provides an API Gateway VPC Link.
 * > **Note:** Amazon API Gateway Version 1 VPC Links enable private integrations that connect REST APIs to private resources in a VPC.
 * To enable private integration for HTTP APIs, use the Amazon API Gateway Version 2 VPC Link resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lb.LoadBalancer("example", {
 *     name: "example",
 *     internal: true,
 *     loadBalancerType: "network",
 *     subnetMappings: [{
 *         subnetId: "12345",
 *     }],
 * });
 * const exampleVpcLink = new aws.apigateway.VpcLink("example", {
 *     name: "example",
 *     description: "example description",
 *     targetArn: example.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lb.LoadBalancer("example",
 *     name="example",
 *     internal=True,
 *     load_balancer_type="network",
 *     subnet_mappings=[{
 *         "subnet_id": "12345",
 *     }])
 * example_vpc_link = aws.apigateway.VpcLink("example",
 *     name="example",
 *     description="example description",
 *     target_arn=example.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.LB.LoadBalancer("example", new()
 *     {
 *         Name = "example",
 *         Internal = true,
 *         LoadBalancerType = "network",
 *         SubnetMappings = new[]
 *         {
 *             new Aws.LB.Inputs.LoadBalancerSubnetMappingArgs
 *             {
 *                 SubnetId = "12345",
 *             },
 *         },
 *     });
 *     var exampleVpcLink = new Aws.ApiGateway.VpcLink("example", new()
 *     {
 *         Name = "example",
 *         Description = "example description",
 *         TargetArn = example.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := lb.NewLoadBalancer(ctx, "example", &lb.LoadBalancerArgs{
 * 			Name:             pulumi.String("example"),
 * 			Internal:         pulumi.Bool(true),
 * 			LoadBalancerType: pulumi.String("network"),
 * 			SubnetMappings: lb.LoadBalancerSubnetMappingArray{
 * 				&lb.LoadBalancerSubnetMappingArgs{
 * 					SubnetId: pulumi.String("12345"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigateway.NewVpcLink(ctx, "example", &apigateway.VpcLinkArgs{
 * 			Name:        pulumi.String("example"),
 * 			Description: pulumi.String("example description"),
 * 			TargetArn:   example.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.LoadBalancer;
 * import com.pulumi.aws.lb.LoadBalancerArgs;
 * import com.pulumi.aws.lb.inputs.LoadBalancerSubnetMappingArgs;
 * import com.pulumi.aws.apigateway.VpcLink;
 * import com.pulumi.aws.apigateway.VpcLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LoadBalancer("example", LoadBalancerArgs.builder()
 *             .name("example")
 *             .internal(true)
 *             .loadBalancerType("network")
 *             .subnetMappings(LoadBalancerSubnetMappingArgs.builder()
 *                 .subnetId("12345")
 *                 .build())
 *             .build());
 *         var exampleVpcLink = new VpcLink("exampleVpcLink", VpcLinkArgs.builder()
 *             .name("example")
 *             .description("example description")
 *             .targetArn(example.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lb:LoadBalancer
 *     properties:
 *       name: example
 *       internal: true
 *       loadBalancerType: network
 *       subnetMappings:
 *         - subnetId: '12345'
 *   exampleVpcLink:
 *     type: aws:apigateway:VpcLink
 *     name: example
 *     properties:
 *       name: example
 *       description: example description
 *       targetArn: ${example.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import API Gateway VPC Link using the `id`. For example:
 * ```sh
 * $ pulumi import aws:apigateway/vpcLink:VpcLink example 12345abcde
 * ```
 */
public class VpcLink internal constructor(
    override val javaResource: com.pulumi.aws.apigateway.VpcLink,
) : KotlinCustomResource(javaResource, VpcLinkMapper) {
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of the VPC link.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name used to label and identify the VPC link.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * List of network load balancer arns in the VPC targeted by the VPC link. Currently AWS only supports 1 target.
     */
    public val targetArn: Output<String>
        get() = javaResource.targetArn().applyValue({ args0 -> args0 })
}

public object VpcLinkMapper : ResourceMapper<VpcLink> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigateway.VpcLink::class == javaResource::class

    override fun map(javaResource: Resource): VpcLink = VpcLink(
        javaResource as
            com.pulumi.aws.apigateway.VpcLink,
    )
}

/**
 * @see [VpcLink].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcLink].
 */
public suspend fun vpcLink(name: String, block: suspend VpcLinkResourceBuilder.() -> Unit): VpcLink {
    val builder = VpcLinkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcLink].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcLink(name: String): VpcLink {
    val builder = VpcLinkResourceBuilder()
    builder.name(name)
    return builder.build()
}
