@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.inputs

import com.pulumi.aws.apigateway.inputs.DeploymentCanarySettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property percentTraffic Percentage (0.0-100.0) of traffic routed to the canary deployment.
 * @property stageVariableOverrides Stage variable overrides used for the canary release deployment. They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.
 * @property useStageCache Boolean flag to indicate whether the canary release deployment uses the stage cache or not.
 */
public data class DeploymentCanarySettingsArgs(
    public val percentTraffic: Output<Double>? = null,
    public val stageVariableOverrides: Output<Map<String, String>>? = null,
    public val useStageCache: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.inputs.DeploymentCanarySettingsArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.inputs.DeploymentCanarySettingsArgs =
        com.pulumi.aws.apigateway.inputs.DeploymentCanarySettingsArgs.builder()
            .percentTraffic(percentTraffic?.applyValue({ args0 -> args0 }))
            .stageVariableOverrides(
                stageVariableOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .useStageCache(useStageCache?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentCanarySettingsArgs].
 */
@PulumiTagMarker
public class DeploymentCanarySettingsArgsBuilder internal constructor() {
    private var percentTraffic: Output<Double>? = null

    private var stageVariableOverrides: Output<Map<String, String>>? = null

    private var useStageCache: Output<Boolean>? = null

    /**
     * @param value Percentage (0.0-100.0) of traffic routed to the canary deployment.
     */
    @JvmName("xioyprtrgcvsvwdo")
    public suspend fun percentTraffic(`value`: Output<Double>) {
        this.percentTraffic = value
    }

    /**
     * @param value Stage variable overrides used for the canary release deployment. They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.
     */
    @JvmName("kvthhyrynranjnnb")
    public suspend fun stageVariableOverrides(`value`: Output<Map<String, String>>) {
        this.stageVariableOverrides = value
    }

    /**
     * @param value Boolean flag to indicate whether the canary release deployment uses the stage cache or not.
     */
    @JvmName("juklvkdhlqhtggmb")
    public suspend fun useStageCache(`value`: Output<Boolean>) {
        this.useStageCache = value
    }

    /**
     * @param value Percentage (0.0-100.0) of traffic routed to the canary deployment.
     */
    @JvmName("nstcqffyffwwpafq")
    public suspend fun percentTraffic(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.percentTraffic = mapped
    }

    /**
     * @param value Stage variable overrides used for the canary release deployment. They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.
     */
    @JvmName("mqcsbwbylyfvahbk")
    public suspend fun stageVariableOverrides(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stageVariableOverrides = mapped
    }

    /**
     * @param values Stage variable overrides used for the canary release deployment. They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.
     */
    @JvmName("lqjoomjsewvlfalp")
    public fun stageVariableOverrides(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stageVariableOverrides = mapped
    }

    /**
     * @param value Boolean flag to indicate whether the canary release deployment uses the stage cache or not.
     */
    @JvmName("ivfoqgrgvbiwqidc")
    public suspend fun useStageCache(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useStageCache = mapped
    }

    internal fun build(): DeploymentCanarySettingsArgs = DeploymentCanarySettingsArgs(
        percentTraffic = percentTraffic,
        stageVariableOverrides = stageVariableOverrides,
        useStageCache = useStageCache,
    )
}
