@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.inputs

import com.pulumi.aws.apigateway.inputs.GetAuthorizerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAuthorizer.
 * @property authorizerId Authorizer identifier.
 * @property restApiId ID of the associated REST API.
 */
public data class GetAuthorizerPlainArgs(
    public val authorizerId: String,
    public val restApiId: String,
) : ConvertibleToJava<com.pulumi.aws.apigateway.inputs.GetAuthorizerPlainArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.inputs.GetAuthorizerPlainArgs =
        com.pulumi.aws.apigateway.inputs.GetAuthorizerPlainArgs.builder()
            .authorizerId(authorizerId.let({ args0 -> args0 }))
            .restApiId(restApiId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAuthorizerPlainArgs].
 */
@PulumiTagMarker
public class GetAuthorizerPlainArgsBuilder internal constructor() {
    private var authorizerId: String? = null

    private var restApiId: String? = null

    /**
     * @param value Authorizer identifier.
     */
    @JvmName("mjmkmcjbhmwjyysp")
    public suspend fun authorizerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authorizerId = mapped
    }

    /**
     * @param value ID of the associated REST API.
     */
    @JvmName("fwuvesbsjfxsanlq")
    public suspend fun restApiId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.restApiId = mapped
    }

    internal fun build(): GetAuthorizerPlainArgs = GetAuthorizerPlainArgs(
        authorizerId = authorizerId ?: throw PulumiNullFieldException("authorizerId"),
        restApiId = restApiId ?: throw PulumiNullFieldException("restApiId"),
    )
}
