@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.inputs

import com.pulumi.aws.apigateway.inputs.GetKeyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getKey.
 * @property id ID of the API Key to look up.
 * @property tags Map of tags for the resource.
 */
public data class GetKeyPlainArgs(
    public val id: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.inputs.GetKeyPlainArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.inputs.GetKeyPlainArgs =
        com.pulumi.aws.apigateway.inputs.GetKeyPlainArgs.builder()
            .id(id.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetKeyPlainArgs].
 */
@PulumiTagMarker
public class GetKeyPlainArgsBuilder internal constructor() {
    private var id: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ID of the API Key to look up.
     */
    @JvmName("fakxdljihjbwbgrn")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Map of tags for the resource.
     */
    @JvmName("quykhstbbtkdmqri")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags for the resource.
     */
    @JvmName("esavtaolpmydcsri")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetKeyPlainArgs = GetKeyPlainArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        tags = tags,
    )
}
