@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.inputs

import com.pulumi.aws.apigateway.inputs.GetResourcePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getResource.
 * @property path Full path of the resource.  If no path is found, an error will be returned.
 * @property restApiId REST API id that owns the resource. If no REST API is found, an error will be returned.
 */
public data class GetResourcePlainArgs(
    public val path: String,
    public val restApiId: String,
) : ConvertibleToJava<com.pulumi.aws.apigateway.inputs.GetResourcePlainArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.inputs.GetResourcePlainArgs =
        com.pulumi.aws.apigateway.inputs.GetResourcePlainArgs.builder()
            .path(path.let({ args0 -> args0 }))
            .restApiId(restApiId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResourcePlainArgs].
 */
@PulumiTagMarker
public class GetResourcePlainArgsBuilder internal constructor() {
    private var path: String? = null

    private var restApiId: String? = null

    /**
     * @param value Full path of the resource.  If no path is found, an error will be returned.
     */
    @JvmName("hxahhcdlrmpefhlj")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.path = mapped
    }

    /**
     * @param value REST API id that owns the resource. If no REST API is found, an error will be returned.
     */
    @JvmName("krgjixslnypbolnl")
    public suspend fun restApiId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.restApiId = mapped
    }

    internal fun build(): GetResourcePlainArgs = GetResourcePlainArgs(
        path = path ?: throw PulumiNullFieldException("path"),
        restApiId = restApiId ?: throw PulumiNullFieldException("restApiId"),
    )
}
