@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.inputs

import com.pulumi.aws.apigateway.inputs.GetRestApiPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRestApi.
 * @property name Name of the REST API to look up. If no REST API is found with this name, an error will be returned. If multiple REST APIs are found with this name, an error will be returned.
 * @property tags Key-value map of resource tags.
 */
public data class GetRestApiPlainArgs(
    public val name: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.inputs.GetRestApiPlainArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.inputs.GetRestApiPlainArgs =
        com.pulumi.aws.apigateway.inputs.GetRestApiPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetRestApiPlainArgs].
 */
@PulumiTagMarker
public class GetRestApiPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the REST API to look up. If no REST API is found with this name, an error will be returned. If multiple REST APIs are found with this name, an error will be returned.
     */
    @JvmName("gpuigqjmmkresnbn")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Key-value map of resource tags.
     */
    @JvmName("yxaceprchgysefue")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags.
     */
    @JvmName("febrklbkbtkogkqt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetRestApiPlainArgs = GetRestApiPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        tags = tags,
    )
}
