@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.inputs

import com.pulumi.aws.apigateway.inputs.IntegrationTlsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property insecureSkipVerification Whether or not API Gateway skips verification that the certificate for an integration endpoint is issued by a [supported certificate authority](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-supported-certificate-authorities-for-http-endpoints.html). This isn’t recommended, but it enables you to use certificates that are signed by private certificate authorities, or certificates that are self-signed. If enabled, API Gateway still performs basic certificate validation, which includes checking the certificate's expiration date, hostname, and presence of a root certificate authority. Supported only for `HTTP` and `HTTP_PROXY` integrations.
 */
public data class IntegrationTlsConfigArgs(
    public val insecureSkipVerification: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.inputs.IntegrationTlsConfigArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.inputs.IntegrationTlsConfigArgs =
        com.pulumi.aws.apigateway.inputs.IntegrationTlsConfigArgs.builder()
            .insecureSkipVerification(insecureSkipVerification?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntegrationTlsConfigArgs].
 */
@PulumiTagMarker
public class IntegrationTlsConfigArgsBuilder internal constructor() {
    private var insecureSkipVerification: Output<Boolean>? = null

    /**
     * @param value Whether or not API Gateway skips verification that the certificate for an integration endpoint is issued by a [supported certificate authority](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-supported-certificate-authorities-for-http-endpoints.html). This isn’t recommended, but it enables you to use certificates that are signed by private certificate authorities, or certificates that are self-signed. If enabled, API Gateway still performs basic certificate validation, which includes checking the certificate's expiration date, hostname, and presence of a root certificate authority. Supported only for `HTTP` and `HTTP_PROXY` integrations.
     */
    @JvmName("lrlguefswrdraikv")
    public suspend fun insecureSkipVerification(`value`: Output<Boolean>) {
        this.insecureSkipVerification = value
    }

    /**
     * @param value Whether or not API Gateway skips verification that the certificate for an integration endpoint is issued by a [supported certificate authority](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-supported-certificate-authorities-for-http-endpoints.html). This isn’t recommended, but it enables you to use certificates that are signed by private certificate authorities, or certificates that are self-signed. If enabled, API Gateway still performs basic certificate validation, which includes checking the certificate's expiration date, hostname, and presence of a root certificate authority. Supported only for `HTTP` and `HTTP_PROXY` integrations.
     */
    @JvmName("xevfsxofisgqrved")
    public suspend fun insecureSkipVerification(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.insecureSkipVerification = mapped
    }

    internal fun build(): IntegrationTlsConfigArgs = IntegrationTlsConfigArgs(
        insecureSkipVerification = insecureSkipVerification,
    )
}
