@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.inputs

import com.pulumi.aws.apigateway.inputs.MethodSettingsSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cacheDataEncrypted Whether the cached responses are encrypted.
 * @property cacheTtlInSeconds Time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached.
 * @property cachingEnabled Whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached.
 * @property dataTraceEnabled Whether data trace logging is enabled for this method, which effects the log entries pushed to Amazon CloudWatch Logs.
 * @property loggingLevel Logging level for this method, which effects the log entries pushed to Amazon CloudWatch Logs. The available levels are `OFF`, `ERROR`, and `INFO`.
 * @property metricsEnabled Whether Amazon CloudWatch metrics are enabled for this method.
 * @property requireAuthorizationForCacheControl Whether authorization is required for a cache invalidation request.
 * @property throttlingBurstLimit Throttling burst limit. Default: `-1` (throttling disabled).
 * @property throttlingRateLimit Throttling rate limit. Default: `-1` (throttling disabled).
 * @property unauthorizedCacheControlHeaderStrategy How to handle unauthorized requests for cache invalidation. The available values are `FAIL_WITH_403`, `SUCCEED_WITH_RESPONSE_HEADER`, `SUCCEED_WITHOUT_RESPONSE_HEADER`.
 */
public data class MethodSettingsSettingsArgs(
    public val cacheDataEncrypted: Output<Boolean>? = null,
    public val cacheTtlInSeconds: Output<Int>? = null,
    public val cachingEnabled: Output<Boolean>? = null,
    public val dataTraceEnabled: Output<Boolean>? = null,
    public val loggingLevel: Output<String>? = null,
    public val metricsEnabled: Output<Boolean>? = null,
    public val requireAuthorizationForCacheControl: Output<Boolean>? = null,
    public val throttlingBurstLimit: Output<Int>? = null,
    public val throttlingRateLimit: Output<Double>? = null,
    public val unauthorizedCacheControlHeaderStrategy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.inputs.MethodSettingsSettingsArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.inputs.MethodSettingsSettingsArgs =
        com.pulumi.aws.apigateway.inputs.MethodSettingsSettingsArgs.builder()
            .cacheDataEncrypted(cacheDataEncrypted?.applyValue({ args0 -> args0 }))
            .cacheTtlInSeconds(cacheTtlInSeconds?.applyValue({ args0 -> args0 }))
            .cachingEnabled(cachingEnabled?.applyValue({ args0 -> args0 }))
            .dataTraceEnabled(dataTraceEnabled?.applyValue({ args0 -> args0 }))
            .loggingLevel(loggingLevel?.applyValue({ args0 -> args0 }))
            .metricsEnabled(metricsEnabled?.applyValue({ args0 -> args0 }))
            .requireAuthorizationForCacheControl(
                requireAuthorizationForCacheControl?.applyValue({ args0 ->
                    args0
                }),
            )
            .throttlingBurstLimit(throttlingBurstLimit?.applyValue({ args0 -> args0 }))
            .throttlingRateLimit(throttlingRateLimit?.applyValue({ args0 -> args0 }))
            .unauthorizedCacheControlHeaderStrategy(
                unauthorizedCacheControlHeaderStrategy?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [MethodSettingsSettingsArgs].
 */
@PulumiTagMarker
public class MethodSettingsSettingsArgsBuilder internal constructor() {
    private var cacheDataEncrypted: Output<Boolean>? = null

    private var cacheTtlInSeconds: Output<Int>? = null

    private var cachingEnabled: Output<Boolean>? = null

    private var dataTraceEnabled: Output<Boolean>? = null

    private var loggingLevel: Output<String>? = null

    private var metricsEnabled: Output<Boolean>? = null

    private var requireAuthorizationForCacheControl: Output<Boolean>? = null

    private var throttlingBurstLimit: Output<Int>? = null

    private var throttlingRateLimit: Output<Double>? = null

    private var unauthorizedCacheControlHeaderStrategy: Output<String>? = null

    /**
     * @param value Whether the cached responses are encrypted.
     */
    @JvmName("uwhsprmqhykdxbia")
    public suspend fun cacheDataEncrypted(`value`: Output<Boolean>) {
        this.cacheDataEncrypted = value
    }

    /**
     * @param value Time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached.
     */
    @JvmName("yhpcdvhtgndkjdjj")
    public suspend fun cacheTtlInSeconds(`value`: Output<Int>) {
        this.cacheTtlInSeconds = value
    }

    /**
     * @param value Whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached.
     */
    @JvmName("krbcqmdupkjuasdf")
    public suspend fun cachingEnabled(`value`: Output<Boolean>) {
        this.cachingEnabled = value
    }

    /**
     * @param value Whether data trace logging is enabled for this method, which effects the log entries pushed to Amazon CloudWatch Logs.
     */
    @JvmName("jwwuejykyiyfcxry")
    public suspend fun dataTraceEnabled(`value`: Output<Boolean>) {
        this.dataTraceEnabled = value
    }

    /**
     * @param value Logging level for this method, which effects the log entries pushed to Amazon CloudWatch Logs. The available levels are `OFF`, `ERROR`, and `INFO`.
     */
    @JvmName("fwnayrkmokrqtybv")
    public suspend fun loggingLevel(`value`: Output<String>) {
        this.loggingLevel = value
    }

    /**
     * @param value Whether Amazon CloudWatch metrics are enabled for this method.
     */
    @JvmName("wibsmrjsryqouqod")
    public suspend fun metricsEnabled(`value`: Output<Boolean>) {
        this.metricsEnabled = value
    }

    /**
     * @param value Whether authorization is required for a cache invalidation request.
     */
    @JvmName("wjyadtotreiyiaho")
    public suspend fun requireAuthorizationForCacheControl(`value`: Output<Boolean>) {
        this.requireAuthorizationForCacheControl = value
    }

    /**
     * @param value Throttling burst limit. Default: `-1` (throttling disabled).
     */
    @JvmName("ytkwyanavtlkxtdy")
    public suspend fun throttlingBurstLimit(`value`: Output<Int>) {
        this.throttlingBurstLimit = value
    }

    /**
     * @param value Throttling rate limit. Default: `-1` (throttling disabled).
     */
    @JvmName("xtkcxymlgxyeitbj")
    public suspend fun throttlingRateLimit(`value`: Output<Double>) {
        this.throttlingRateLimit = value
    }

    /**
     * @param value How to handle unauthorized requests for cache invalidation. The available values are `FAIL_WITH_403`, `SUCCEED_WITH_RESPONSE_HEADER`, `SUCCEED_WITHOUT_RESPONSE_HEADER`.
     */
    @JvmName("hxldjofxnrxpjubj")
    public suspend fun unauthorizedCacheControlHeaderStrategy(`value`: Output<String>) {
        this.unauthorizedCacheControlHeaderStrategy = value
    }

    /**
     * @param value Whether the cached responses are encrypted.
     */
    @JvmName("qbawgwnlxpojolxk")
    public suspend fun cacheDataEncrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheDataEncrypted = mapped
    }

    /**
     * @param value Time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached.
     */
    @JvmName("lcdussaljkhoitgi")
    public suspend fun cacheTtlInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheTtlInSeconds = mapped
    }

    /**
     * @param value Whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached.
     */
    @JvmName("gqjmvshotrbvcrtc")
    public suspend fun cachingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cachingEnabled = mapped
    }

    /**
     * @param value Whether data trace logging is enabled for this method, which effects the log entries pushed to Amazon CloudWatch Logs.
     */
    @JvmName("xcvrmqwrlidsevwv")
    public suspend fun dataTraceEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataTraceEnabled = mapped
    }

    /**
     * @param value Logging level for this method, which effects the log entries pushed to Amazon CloudWatch Logs. The available levels are `OFF`, `ERROR`, and `INFO`.
     */
    @JvmName("xvvuadfoybtjjwjs")
    public suspend fun loggingLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingLevel = mapped
    }

    /**
     * @param value Whether Amazon CloudWatch metrics are enabled for this method.
     */
    @JvmName("eepolgsjmkhhshjd")
    public suspend fun metricsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricsEnabled = mapped
    }

    /**
     * @param value Whether authorization is required for a cache invalidation request.
     */
    @JvmName("grjsuveoqctopwxt")
    public suspend fun requireAuthorizationForCacheControl(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireAuthorizationForCacheControl = mapped
    }

    /**
     * @param value Throttling burst limit. Default: `-1` (throttling disabled).
     */
    @JvmName("nvhcpyggxykkaqsq")
    public suspend fun throttlingBurstLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttlingBurstLimit = mapped
    }

    /**
     * @param value Throttling rate limit. Default: `-1` (throttling disabled).
     */
    @JvmName("tvdstpljsmpxxgkh")
    public suspend fun throttlingRateLimit(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttlingRateLimit = mapped
    }

    /**
     * @param value How to handle unauthorized requests for cache invalidation. The available values are `FAIL_WITH_403`, `SUCCEED_WITH_RESPONSE_HEADER`, `SUCCEED_WITHOUT_RESPONSE_HEADER`.
     */
    @JvmName("abayanxbaasgxywv")
    public suspend fun unauthorizedCacheControlHeaderStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unauthorizedCacheControlHeaderStrategy = mapped
    }

    internal fun build(): MethodSettingsSettingsArgs = MethodSettingsSettingsArgs(
        cacheDataEncrypted = cacheDataEncrypted,
        cacheTtlInSeconds = cacheTtlInSeconds,
        cachingEnabled = cachingEnabled,
        dataTraceEnabled = dataTraceEnabled,
        loggingLevel = loggingLevel,
        metricsEnabled = metricsEnabled,
        requireAuthorizationForCacheControl = requireAuthorizationForCacheControl,
        throttlingBurstLimit = throttlingBurstLimit,
        throttlingRateLimit = throttlingRateLimit,
        unauthorizedCacheControlHeaderStrategy = unauthorizedCacheControlHeaderStrategy,
    )
}
