@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.inputs

import com.pulumi.aws.apigateway.inputs.StageCanarySettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property percentTraffic Percent `0.0` - `100.0` of traffic to divert to the canary deployment.
 * @property stageVariableOverrides Map of overridden stage `variables` (including new variables) for the canary deployment.
 * @property useStageCache Whether the canary deployment uses the stage cache. Defaults to false.
 */
public data class StageCanarySettingsArgs(
    public val percentTraffic: Output<Double>? = null,
    public val stageVariableOverrides: Output<Map<String, String>>? = null,
    public val useStageCache: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.inputs.StageCanarySettingsArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.inputs.StageCanarySettingsArgs =
        com.pulumi.aws.apigateway.inputs.StageCanarySettingsArgs.builder()
            .percentTraffic(percentTraffic?.applyValue({ args0 -> args0 }))
            .stageVariableOverrides(
                stageVariableOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .useStageCache(useStageCache?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StageCanarySettingsArgs].
 */
@PulumiTagMarker
public class StageCanarySettingsArgsBuilder internal constructor() {
    private var percentTraffic: Output<Double>? = null

    private var stageVariableOverrides: Output<Map<String, String>>? = null

    private var useStageCache: Output<Boolean>? = null

    /**
     * @param value Percent `0.0` - `100.0` of traffic to divert to the canary deployment.
     */
    @JvmName("ulqovinnhhnwrokf")
    public suspend fun percentTraffic(`value`: Output<Double>) {
        this.percentTraffic = value
    }

    /**
     * @param value Map of overridden stage `variables` (including new variables) for the canary deployment.
     */
    @JvmName("yrnblnpladiotqye")
    public suspend fun stageVariableOverrides(`value`: Output<Map<String, String>>) {
        this.stageVariableOverrides = value
    }

    /**
     * @param value Whether the canary deployment uses the stage cache. Defaults to false.
     */
    @JvmName("tduigjrihjmietco")
    public suspend fun useStageCache(`value`: Output<Boolean>) {
        this.useStageCache = value
    }

    /**
     * @param value Percent `0.0` - `100.0` of traffic to divert to the canary deployment.
     */
    @JvmName("ejyunfbfwlsjpbqf")
    public suspend fun percentTraffic(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.percentTraffic = mapped
    }

    /**
     * @param value Map of overridden stage `variables` (including new variables) for the canary deployment.
     */
    @JvmName("ubkasrrbpskluhsl")
    public suspend fun stageVariableOverrides(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stageVariableOverrides = mapped
    }

    /**
     * @param values Map of overridden stage `variables` (including new variables) for the canary deployment.
     */
    @JvmName("nyycniuhqxhtysyd")
    public fun stageVariableOverrides(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stageVariableOverrides = mapped
    }

    /**
     * @param value Whether the canary deployment uses the stage cache. Defaults to false.
     */
    @JvmName("kaijkdopgnsflybv")
    public suspend fun useStageCache(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useStageCache = mapped
    }

    internal fun build(): StageCanarySettingsArgs = StageCanarySettingsArgs(
        percentTraffic = percentTraffic,
        stageVariableOverrides = stageVariableOverrides,
        useStageCache = useStageCache,
    )
}
