@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.inputs

import com.pulumi.aws.apigateway.inputs.UsagePlanApiStageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property apiId API Id of the associated API stage in a usage plan.
 * @property stage API stage name of the associated API stage in a usage plan.
 * @property throttles The throttling limits of the usage plan.
 */
public data class UsagePlanApiStageArgs(
    public val apiId: Output<String>,
    public val stage: Output<String>,
    public val throttles: Output<List<UsagePlanApiStageThrottleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.inputs.UsagePlanApiStageArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.inputs.UsagePlanApiStageArgs =
        com.pulumi.aws.apigateway.inputs.UsagePlanApiStageArgs.builder()
            .apiId(apiId.applyValue({ args0 -> args0 }))
            .stage(stage.applyValue({ args0 -> args0 }))
            .throttles(
                throttles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [UsagePlanApiStageArgs].
 */
@PulumiTagMarker
public class UsagePlanApiStageArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var stage: Output<String>? = null

    private var throttles: Output<List<UsagePlanApiStageThrottleArgs>>? = null

    /**
     * @param value API Id of the associated API stage in a usage plan.
     */
    @JvmName("gnbetgymtklpauqq")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value API stage name of the associated API stage in a usage plan.
     */
    @JvmName("imapbkuqojsdjjoq")
    public suspend fun stage(`value`: Output<String>) {
        this.stage = value
    }

    /**
     * @param value The throttling limits of the usage plan.
     */
    @JvmName("wpfivntnpbaummnw")
    public suspend fun throttles(`value`: Output<List<UsagePlanApiStageThrottleArgs>>) {
        this.throttles = value
    }

    @JvmName("vxqkkebyfwftjope")
    public suspend fun throttles(vararg values: Output<UsagePlanApiStageThrottleArgs>) {
        this.throttles = Output.all(values.asList())
    }

    /**
     * @param values The throttling limits of the usage plan.
     */
    @JvmName("yjuqqicsnljqyggv")
    public suspend fun throttles(values: List<Output<UsagePlanApiStageThrottleArgs>>) {
        this.throttles = Output.all(values)
    }

    /**
     * @param value API Id of the associated API stage in a usage plan.
     */
    @JvmName("npjsnrnhtifiston")
    public suspend fun apiId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value API stage name of the associated API stage in a usage plan.
     */
    @JvmName("tdhcwvhutudrgxwu")
    public suspend fun stage(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stage = mapped
    }

    /**
     * @param value The throttling limits of the usage plan.
     */
    @JvmName("eaxjveogyfpkbjau")
    public suspend fun throttles(`value`: List<UsagePlanApiStageThrottleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttles = mapped
    }

    /**
     * @param argument The throttling limits of the usage plan.
     */
    @JvmName("cebywbllvpoeufuk")
    public suspend fun throttles(argument: List<suspend UsagePlanApiStageThrottleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UsagePlanApiStageThrottleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.throttles = mapped
    }

    /**
     * @param argument The throttling limits of the usage plan.
     */
    @JvmName("tfotmxblvuitoigb")
    public suspend fun throttles(vararg argument: suspend UsagePlanApiStageThrottleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UsagePlanApiStageThrottleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.throttles = mapped
    }

    /**
     * @param argument The throttling limits of the usage plan.
     */
    @JvmName("lcpsoffngshebpgs")
    public suspend fun throttles(argument: suspend UsagePlanApiStageThrottleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            UsagePlanApiStageThrottleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.throttles = mapped
    }

    /**
     * @param values The throttling limits of the usage plan.
     */
    @JvmName("ekoslqoctmqwaguy")
    public suspend fun throttles(vararg values: UsagePlanApiStageThrottleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.throttles = mapped
    }

    internal fun build(): UsagePlanApiStageArgs = UsagePlanApiStageArgs(
        apiId = apiId ?: throw PulumiNullFieldException("apiId"),
        stage = stage ?: throw PulumiNullFieldException("stage"),
        throttles = throttles,
    )
}
