@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.inputs

import com.pulumi.aws.apigateway.inputs.UsagePlanThrottleSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property burstLimit
 * @property rateLimit
 */
public data class UsagePlanThrottleSettingsArgs(
    public val burstLimit: Output<Int>? = null,
    public val rateLimit: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.inputs.UsagePlanThrottleSettingsArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.inputs.UsagePlanThrottleSettingsArgs =
        com.pulumi.aws.apigateway.inputs.UsagePlanThrottleSettingsArgs.builder()
            .burstLimit(burstLimit?.applyValue({ args0 -> args0 }))
            .rateLimit(rateLimit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UsagePlanThrottleSettingsArgs].
 */
@PulumiTagMarker
public class UsagePlanThrottleSettingsArgsBuilder internal constructor() {
    private var burstLimit: Output<Int>? = null

    private var rateLimit: Output<Double>? = null

    /**
     * @param value
     */
    @JvmName("qjxmplukqixmxmhe")
    public suspend fun burstLimit(`value`: Output<Int>) {
        this.burstLimit = value
    }

    /**
     * @param value
     */
    @JvmName("eujjsgbkgdvjiuqq")
    public suspend fun rateLimit(`value`: Output<Double>) {
        this.rateLimit = value
    }

    /**
     * @param value
     */
    @JvmName("oddkvqyxnxmhuajb")
    public suspend fun burstLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.burstLimit = mapped
    }

    /**
     * @param value
     */
    @JvmName("wdqqwktlicoxxbgw")
    public suspend fun rateLimit(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rateLimit = mapped
    }

    internal fun build(): UsagePlanThrottleSettingsArgs = UsagePlanThrottleSettingsArgs(
        burstLimit = burstLimit,
        rateLimit = rateLimit,
    )
}
