@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property percentTraffic Percentage (0.0-100.0) of traffic routed to the canary deployment.
 * @property stageVariableOverrides Stage variable overrides used for the canary release deployment. They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.
 * @property useStageCache Boolean flag to indicate whether the canary release deployment uses the stage cache or not.
 */
public data class DeploymentCanarySettings(
    public val percentTraffic: Double? = null,
    public val stageVariableOverrides: Map<String, String>? = null,
    public val useStageCache: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigateway.outputs.DeploymentCanarySettings): DeploymentCanarySettings = DeploymentCanarySettings(
            percentTraffic = javaType.percentTraffic().map({ args0 -> args0 }).orElse(null),
            stageVariableOverrides = javaType.stageVariableOverrides().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            useStageCache = javaType.useStageCache().map({ args0 -> args0 }).orElse(null),
        )
    }
}
