@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property method HTTP verb of a method. The default value is `*` for any method.
 * @property name Name of the targeted API entity.
 * @property path URL path of the target. The default value is `/` for the root resource.
 * @property statusCode HTTP status code of a response. The default value is `*` for any status code.
 * @property type Type of API entity to which the documentation content appliesE.g., `API`, `METHOD` or `REQUEST_BODY`
 */
public data class DocumentationPartLocation(
    public val method: String? = null,
    public val name: String? = null,
    public val path: String? = null,
    public val statusCode: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigateway.outputs.DocumentationPartLocation): DocumentationPartLocation = DocumentationPartLocation(
            method = javaType.method().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            statusCode = javaType.statusCode().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
