@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property types List of endpoint types. This resource currently only supports managing a single value. Valid values: `EDGE` or `REGIONAL`. If unspecified, defaults to `EDGE`. Must be declared as `REGIONAL` in non-Commercial partitions. Refer to the [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/create-regional-api.html) for more information on the difference between edge-optimized and regional APIs.
 */
public data class DomainNameEndpointConfiguration(
    public val types: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigateway.outputs.DomainNameEndpointConfiguration): DomainNameEndpointConfiguration = DomainNameEndpointConfiguration(
            types = javaType.types(),
        )
    }
}
