@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAuthorizers.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids List of Authorizer identifiers.
 * @property restApiId
 */
public data class GetAuthorizersResult(
    public val id: String,
    public val ids: List<String>,
    public val restApiId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigateway.outputs.GetAuthorizersResult): GetAuthorizersResult = GetAuthorizersResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            restApiId = javaType.restApiId(),
        )
    }
}
