@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getDomainName.
 * @property arn ARN of the found custom domain name.
 * @property certificateArn ARN for an AWS-managed certificate that is used by edge-optimized endpoint for this domain name.
 * @property certificateName Name of the certificate that is used by edge-optimized endpoint for this domain name.
 * @property certificateUploadDate Upload date associated with the domain certificate.
 * @property cloudfrontDomainName Hostname created by Cloudfront to represent the distribution that implements this domain name mapping.
 * @property cloudfrontZoneId For convenience, the hosted zone ID (`Z2FDTNDATAQYW2`) that can be used to create a Route53 alias record for the distribution.
 * @property domainName
 * @property endpointConfigurations List of objects with the endpoint configuration of this domain name.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property regionalCertificateArn ARN for an AWS-managed certificate that is used for validating the regional domain name.
 * @property regionalCertificateName User-friendly name of the certificate that is used by regional endpoint for this domain name.
 * @property regionalDomainName Hostname for the custom domain's regional endpoint.
 * @property regionalZoneId Hosted zone ID that can be used to create a Route53 alias record for the regional endpoint.
 * @property securityPolicy Security policy for the domain name.
 * @property tags Key-value map of tags for the resource.
 */
public data class GetDomainNameResult(
    public val arn: String,
    public val certificateArn: String,
    public val certificateName: String,
    public val certificateUploadDate: String,
    public val cloudfrontDomainName: String,
    public val cloudfrontZoneId: String,
    public val domainName: String,
    public val endpointConfigurations: List<GetDomainNameEndpointConfiguration>,
    public val id: String,
    public val regionalCertificateArn: String,
    public val regionalCertificateName: String,
    public val regionalDomainName: String,
    public val regionalZoneId: String,
    public val securityPolicy: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigateway.outputs.GetDomainNameResult): GetDomainNameResult = GetDomainNameResult(
            arn = javaType.arn(),
            certificateArn = javaType.certificateArn(),
            certificateName = javaType.certificateName(),
            certificateUploadDate = javaType.certificateUploadDate(),
            cloudfrontDomainName = javaType.cloudfrontDomainName(),
            cloudfrontZoneId = javaType.cloudfrontZoneId(),
            domainName = javaType.domainName(),
            endpointConfigurations = javaType.endpointConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.apigateway.kotlin.outputs.GetDomainNameEndpointConfiguration.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            regionalCertificateArn = javaType.regionalCertificateArn(),
            regionalCertificateName = javaType.regionalCertificateName(),
            regionalDomainName = javaType.regionalDomainName(),
            regionalZoneId = javaType.regionalZoneId(),
            securityPolicy = javaType.securityPolicy(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
