@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getExport.
 * @property accepts
 * @property body API Spec.
 * @property contentDisposition Content-disposition header value in the HTTP response.
 * @property contentType Content-type header value in the HTTP response.
 * @property exportType
 * @property id The provider-assigned unique ID for this managed resource.
 * @property parameters
 * @property restApiId
 * @property stageName
 */
public data class GetExportResult(
    public val accepts: String? = null,
    public val body: String,
    public val contentDisposition: String,
    public val contentType: String,
    public val exportType: String,
    public val id: String,
    public val parameters: Map<String, String>? = null,
    public val restApiId: String,
    public val stageName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigateway.outputs.GetExportResult): GetExportResult = GetExportResult(
            accepts = javaType.accepts().map({ args0 -> args0 }).orElse(null),
            body = javaType.body(),
            contentDisposition = javaType.contentDisposition(),
            contentType = javaType.contentType(),
            exportType = javaType.exportType(),
            id = javaType.id(),
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            restApiId = javaType.restApiId(),
            stageName = javaType.stageName(),
        )
    }
}
