@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getKey.
 * @property createdDate Date and time when the API Key was created.
 * @property customerId Amazon Web Services Marketplace customer identifier, when integrating with the Amazon Web Services SaaS Marketplace.
 * @property description Description of the API Key.
 * @property enabled Whether the API Key is enabled.
 * @property id Set to the ID of the API Key.
 * @property lastUpdatedDate Date and time when the API Key was last updated.
 * @property name Set to the name of the API Key.
 * @property tags Map of tags for the resource.
 * @property value Set to the value of the API Key.
 */
public data class GetKeyResult(
    public val createdDate: String,
    public val customerId: String,
    public val description: String,
    public val enabled: Boolean,
    public val id: String,
    public val lastUpdatedDate: String,
    public val name: String,
    public val tags: Map<String, String>,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigateway.outputs.GetKeyResult): GetKeyResult =
            GetKeyResult(
                createdDate = javaType.createdDate(),
                customerId = javaType.customerId(),
                description = javaType.description(),
                enabled = javaType.enabled(),
                id = javaType.id(),
                lastUpdatedDate = javaType.lastUpdatedDate(),
                name = javaType.name(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                `value` = javaType.`value`(),
            )
    }
}
