@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getResource.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property parentId Set to the ID of the parent Resource.
 * @property path
 * @property pathPart Set to the path relative to the parent Resource.
 * @property restApiId
 */
public data class GetResourceResult(
    public val id: String,
    public val parentId: String,
    public val path: String,
    public val pathPart: String,
    public val restApiId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigateway.outputs.GetResourceResult): GetResourceResult = GetResourceResult(
            id = javaType.id(),
            parentId = javaType.parentId(),
            path = javaType.path(),
            pathPart = javaType.pathPart(),
            restApiId = javaType.restApiId(),
        )
    }
}
