@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getSdk.
 * @property body SDK as a string.
 * @property contentDisposition Content-disposition header value in the HTTP response.
 * @property contentType Content-type header value in the HTTP response.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property parameters
 * @property restApiId
 * @property sdkType
 * @property stageName
 */
public data class GetSdkResult(
    public val body: String,
    public val contentDisposition: String,
    public val contentType: String,
    public val id: String,
    public val parameters: Map<String, String>? = null,
    public val restApiId: String,
    public val sdkType: String,
    public val stageName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigateway.outputs.GetSdkResult): GetSdkResult =
            GetSdkResult(
                body = javaType.body(),
                contentDisposition = javaType.contentDisposition(),
                contentType = javaType.contentType(),
                id = javaType.id(),
                parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                restApiId = javaType.restApiId(),
                sdkType = javaType.sdkType(),
                stageName = javaType.stageName(),
            )
    }
}
