@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property insecureSkipVerification Whether or not API Gateway skips verification that the certificate for an integration endpoint is issued by a [supported certificate authority](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-supported-certificate-authorities-for-http-endpoints.html). This isn’t recommended, but it enables you to use certificates that are signed by private certificate authorities, or certificates that are self-signed. If enabled, API Gateway still performs basic certificate validation, which includes checking the certificate's expiration date, hostname, and presence of a root certificate authority. Supported only for `HTTP` and `HTTP_PROXY` integrations.
 */
public data class IntegrationTlsConfig(
    public val insecureSkipVerification: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigateway.outputs.IntegrationTlsConfig): IntegrationTlsConfig = IntegrationTlsConfig(
            insecureSkipVerification = javaType.insecureSkipVerification().map({ args0 -> args0 }).orElse(null),
        )
    }
}
