@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cacheDataEncrypted Whether the cached responses are encrypted.
 * @property cacheTtlInSeconds Time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached.
 * @property cachingEnabled Whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached.
 * @property dataTraceEnabled Whether data trace logging is enabled for this method, which effects the log entries pushed to Amazon CloudWatch Logs.
 * @property loggingLevel Logging level for this method, which effects the log entries pushed to Amazon CloudWatch Logs. The available levels are `OFF`, `ERROR`, and `INFO`.
 * @property metricsEnabled Whether Amazon CloudWatch metrics are enabled for this method.
 * @property requireAuthorizationForCacheControl Whether authorization is required for a cache invalidation request.
 * @property throttlingBurstLimit Throttling burst limit. Default: `-1` (throttling disabled).
 * @property throttlingRateLimit Throttling rate limit. Default: `-1` (throttling disabled).
 * @property unauthorizedCacheControlHeaderStrategy How to handle unauthorized requests for cache invalidation. The available values are `FAIL_WITH_403`, `SUCCEED_WITH_RESPONSE_HEADER`, `SUCCEED_WITHOUT_RESPONSE_HEADER`.
 */
public data class MethodSettingsSettings(
    public val cacheDataEncrypted: Boolean? = null,
    public val cacheTtlInSeconds: Int? = null,
    public val cachingEnabled: Boolean? = null,
    public val dataTraceEnabled: Boolean? = null,
    public val loggingLevel: String? = null,
    public val metricsEnabled: Boolean? = null,
    public val requireAuthorizationForCacheControl: Boolean? = null,
    public val throttlingBurstLimit: Int? = null,
    public val throttlingRateLimit: Double? = null,
    public val unauthorizedCacheControlHeaderStrategy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigateway.outputs.MethodSettingsSettings): MethodSettingsSettings = MethodSettingsSettings(
            cacheDataEncrypted = javaType.cacheDataEncrypted().map({ args0 -> args0 }).orElse(null),
            cacheTtlInSeconds = javaType.cacheTtlInSeconds().map({ args0 -> args0 }).orElse(null),
            cachingEnabled = javaType.cachingEnabled().map({ args0 -> args0 }).orElse(null),
            dataTraceEnabled = javaType.dataTraceEnabled().map({ args0 -> args0 }).orElse(null),
            loggingLevel = javaType.loggingLevel().map({ args0 -> args0 }).orElse(null),
            metricsEnabled = javaType.metricsEnabled().map({ args0 -> args0 }).orElse(null),
            requireAuthorizationForCacheControl = javaType.requireAuthorizationForCacheControl().map({ args0 ->
                args0
            }).orElse(null),
            throttlingBurstLimit = javaType.throttlingBurstLimit().map({ args0 -> args0 }).orElse(null),
            throttlingRateLimit = javaType.throttlingRateLimit().map({ args0 -> args0 }).orElse(null),
            unauthorizedCacheControlHeaderStrategy = javaType.unauthorizedCacheControlHeaderStrategy().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
