@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property destinationArn ARN of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with `amazon-apigateway-`. Automatically removes trailing `:*` if present.
 * @property format Formatting and values recorded in the logs.
 * For more information on configuring the log format rules visit the AWS [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html)
 */
public data class StageAccessLogSettings(
    public val destinationArn: String,
    public val format: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigateway.outputs.StageAccessLogSettings): StageAccessLogSettings = StageAccessLogSettings(
            destinationArn = javaType.destinationArn(),
            format = javaType.format(),
        )
    }
}
