@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property burstLimit The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon whether the underlying token bucket is at its full capacity.
 * @property path Method to apply the throttle settings for. Specfiy the path and method, for example `/test/GET`.
 * @property rateLimit The API request steady-state rate limit.
 */
public data class UsagePlanApiStageThrottle(
    public val burstLimit: Int? = null,
    public val path: String,
    public val rateLimit: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigateway.outputs.UsagePlanApiStageThrottle): UsagePlanApiStageThrottle = UsagePlanApiStageThrottle(
            burstLimit = javaType.burstLimit().map({ args0 -> args0 }).orElse(null),
            path = javaType.path(),
            rateLimit = javaType.rateLimit().map({ args0 -> args0 }).orElse(null),
        )
    }
}
