@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property limit Maximum number of requests that can be made in a given time period.
 * @property offset Number of requests subtracted from the given limit in the initial time period.
 * @property period Time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".
 */
public data class UsagePlanQuotaSettings(
    public val limit: Int,
    public val offset: Int? = null,
    public val period: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigateway.outputs.UsagePlanQuotaSettings): UsagePlanQuotaSettings = UsagePlanQuotaSettings(
            limit = javaType.limit(),
            offset = javaType.offset().map({ args0 -> args0 }).orElse(null),
            period = javaType.period(),
        )
    }
}
