@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.kotlin.outputs.ApiCorsConfiguration
import com.pulumi.aws.apigatewayv2.kotlin.outputs.ApiCorsConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Api].
 */
@PulumiTagMarker
public class ApiResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApiArgs = ApiArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApiArgsBuilder.() -> Unit) {
        val builder = ApiArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Api {
        val builtJavaResource = com.pulumi.aws.apigatewayv2.Api(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Api(builtJavaResource)
    }
}

/**
 * Manages an Amazon API Gateway Version 2 API.
 * > **Note:** Amazon API Gateway Version 2 resources are used for creating and deploying WebSocket and HTTP APIs. To create and deploy REST APIs, use Amazon API Gateway Version 1 resources.
 * ## Example Usage
 * ### Basic WebSocket API
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apigatewayv2.Api("example", {
 *     name: "example-websocket-api",
 *     protocolType: "WEBSOCKET",
 *     routeSelectionExpression: "$request.body.action",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apigatewayv2.Api("example",
 *     name="example-websocket-api",
 *     protocol_type="WEBSOCKET",
 *     route_selection_expression="$request.body.action")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ApiGatewayV2.Api("example", new()
 *     {
 *         Name = "example-websocket-api",
 *         ProtocolType = "WEBSOCKET",
 *         RouteSelectionExpression = "$request.body.action",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigatewayv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigatewayv2.NewApi(ctx, "example", &apigatewayv2.ApiArgs{
 * 			Name:                     pulumi.String("example-websocket-api"),
 * 			ProtocolType:             pulumi.String("WEBSOCKET"),
 * 			RouteSelectionExpression: pulumi.String("$request.body.action"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Api;
 * import com.pulumi.aws.apigatewayv2.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Api("example", ApiArgs.builder()
 *             .name("example-websocket-api")
 *             .protocolType("WEBSOCKET")
 *             .routeSelectionExpression("$request.body.action")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apigatewayv2:Api
 *     properties:
 *       name: example-websocket-api
 *       protocolType: WEBSOCKET
 *       routeSelectionExpression: $request.body.action
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Basic HTTP API
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apigatewayv2.Api("example", {
 *     name: "example-http-api",
 *     protocolType: "HTTP",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apigatewayv2.Api("example",
 *     name="example-http-api",
 *     protocol_type="HTTP")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ApiGatewayV2.Api("example", new()
 *     {
 *         Name = "example-http-api",
 *         ProtocolType = "HTTP",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigatewayv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigatewayv2.NewApi(ctx, "example", &apigatewayv2.ApiArgs{
 * 			Name:         pulumi.String("example-http-api"),
 * 			ProtocolType: pulumi.String("HTTP"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Api;
 * import com.pulumi.aws.apigatewayv2.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Api("example", ApiArgs.builder()
 *             .name("example-http-api")
 *             .protocolType("HTTP")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apigatewayv2:Api
 *     properties:
 *       name: example-http-api
 *       protocolType: HTTP
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_api` using the API identifier. For example:
 * ```sh
 * $ pulumi import aws:apigatewayv2/api:Api example aabbccddee
 * ```
 */
public class Api internal constructor(
    override val javaResource: com.pulumi.aws.apigatewayv2.Api,
) : KotlinCustomResource(javaResource, ApiMapper) {
    /**
     * URI of the API, of the form `https://{api-id}.execute-api.{region}.amazonaws.com` for HTTP APIs and `wss://{api-id}.execute-api.{region}.amazonaws.com` for WebSocket APIs.
     */
    public val apiEndpoint: Output<String>
        get() = javaResource.apiEndpoint().applyValue({ args0 -> args0 })

    /**
     * An [API key selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
     * Valid values: `$context.authorizer.usageIdentifierKey`, `$request.header.x-api-key`. Defaults to `$request.header.x-api-key`.
     * Applicable for WebSocket APIs.
     */
    public val apiKeySelectionExpression: Output<String>?
        get() = javaResource.apiKeySelectionExpression().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the API.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * An OpenAPI specification that defines the set of routes and integrations to create as part of the HTTP APIs. Supported only for HTTP APIs.
     */
    public val body: Output<String>?
        get() = javaResource.body().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Cross-origin resource sharing (CORS) [configuration](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html). Applicable for HTTP APIs.
     */
    public val corsConfiguration: Output<ApiCorsConfiguration>?
        get() = javaResource.corsConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Part of _quick create_. Specifies any credentials required for the integration. Applicable for HTTP APIs.
     */
    public val credentialsArn: Output<String>?
        get() = javaResource.credentialsArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description of the API. Must be less than or equal to 1024 characters in length.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether clients can invoke the API by using the default `execute-api` endpoint.
     * By default, clients can invoke the API with the default `{api_id}.execute-api.{region}.amazonaws.com endpoint`.
     * To require that clients use a custom domain name to invoke the API, disable the default endpoint.
     */
    public val disableExecuteApiEndpoint: Output<Boolean>?
        get() = javaResource.disableExecuteApiEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN prefix to be used in an `aws.lambda.Permission`'s `source_arn` attribute
     * or in an `aws.iam.Policy` to authorize access to the [`@connections` API](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-how-to-call-websocket-api-connections.html).
     * See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-control-access-iam.html) for details.
     */
    public val executionArn: Output<String>
        get() = javaResource.executionArn().applyValue({ args0 -> args0 })

    /**
     * Whether warnings should return an error while API Gateway is creating or updating the resource using an OpenAPI specification. Defaults to `false`. Applicable for HTTP APIs.
     */
    public val failOnWarnings: Output<Boolean>?
        get() = javaResource.failOnWarnings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the API. Must be less than or equal to 128 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * API protocol. Valid values: `HTTP`, `WEBSOCKET`.
     */
    public val protocolType: Output<String>
        get() = javaResource.protocolType().applyValue({ args0 -> args0 })

    /**
     * Part of _quick create_. Specifies any [route key](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-routes.html). Applicable for HTTP APIs.
     */
    public val routeKey: Output<String>?
        get() = javaResource.routeKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The [route selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-route-selection-expressions) for the API.
     * Defaults to `$request.method $request.path`.
     */
    public val routeSelectionExpression: Output<String>?
        get() = javaResource.routeSelectionExpression().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Map of tags to assign to the API. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Part of _quick create_. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes.
     * For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN.
     * The type of the integration will be `HTTP_PROXY` or `AWS_PROXY`, respectively. Applicable for HTTP APIs.
     */
    public val target: Output<String>?
        get() = javaResource.target().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Version identifier for the API. Must be between 1 and 64 characters in length.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ApiMapper : ResourceMapper<Api> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigatewayv2.Api::class == javaResource::class

    override fun map(javaResource: Resource): Api = Api(
        javaResource as
            com.pulumi.aws.apigatewayv2.Api,
    )
}

/**
 * @see [Api].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Api].
 */
public suspend fun api(name: String, block: suspend ApiResourceBuilder.() -> Unit): Api {
    val builder = ApiResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Api].
 * @param name The _unique_ name of the resulting resource.
 */
public fun api(name: String): Api {
    val builder = ApiResourceBuilder()
    builder.name(name)
    return builder.build()
}
