@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.ApiArgs.builder
import com.pulumi.aws.apigatewayv2.kotlin.inputs.ApiCorsConfigurationArgs
import com.pulumi.aws.apigatewayv2.kotlin.inputs.ApiCorsConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Amazon API Gateway Version 2 API.
 * > **Note:** Amazon API Gateway Version 2 resources are used for creating and deploying WebSocket and HTTP APIs. To create and deploy REST APIs, use Amazon API Gateway Version 1 resources.
 * ## Example Usage
 * ### Basic WebSocket API
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apigatewayv2.Api("example", {
 *     name: "example-websocket-api",
 *     protocolType: "WEBSOCKET",
 *     routeSelectionExpression: "$request.body.action",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apigatewayv2.Api("example",
 *     name="example-websocket-api",
 *     protocol_type="WEBSOCKET",
 *     route_selection_expression="$request.body.action")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ApiGatewayV2.Api("example", new()
 *     {
 *         Name = "example-websocket-api",
 *         ProtocolType = "WEBSOCKET",
 *         RouteSelectionExpression = "$request.body.action",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigatewayv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigatewayv2.NewApi(ctx, "example", &apigatewayv2.ApiArgs{
 * 			Name:                     pulumi.String("example-websocket-api"),
 * 			ProtocolType:             pulumi.String("WEBSOCKET"),
 * 			RouteSelectionExpression: pulumi.String("$request.body.action"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Api;
 * import com.pulumi.aws.apigatewayv2.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Api("example", ApiArgs.builder()
 *             .name("example-websocket-api")
 *             .protocolType("WEBSOCKET")
 *             .routeSelectionExpression("$request.body.action")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apigatewayv2:Api
 *     properties:
 *       name: example-websocket-api
 *       protocolType: WEBSOCKET
 *       routeSelectionExpression: $request.body.action
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Basic HTTP API
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apigatewayv2.Api("example", {
 *     name: "example-http-api",
 *     protocolType: "HTTP",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apigatewayv2.Api("example",
 *     name="example-http-api",
 *     protocol_type="HTTP")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ApiGatewayV2.Api("example", new()
 *     {
 *         Name = "example-http-api",
 *         ProtocolType = "HTTP",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigatewayv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigatewayv2.NewApi(ctx, "example", &apigatewayv2.ApiArgs{
 * 			Name:         pulumi.String("example-http-api"),
 * 			ProtocolType: pulumi.String("HTTP"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Api;
 * import com.pulumi.aws.apigatewayv2.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Api("example", ApiArgs.builder()
 *             .name("example-http-api")
 *             .protocolType("HTTP")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apigatewayv2:Api
 *     properties:
 *       name: example-http-api
 *       protocolType: HTTP
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_api` using the API identifier. For example:
 * ```sh
 * $ pulumi import aws:apigatewayv2/api:Api example aabbccddee
 * ```
 * @property apiKeySelectionExpression An [API key selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
 * Valid values: `$context.authorizer.usageIdentifierKey`, `$request.header.x-api-key`. Defaults to `$request.header.x-api-key`.
 * Applicable for WebSocket APIs.
 * @property body An OpenAPI specification that defines the set of routes and integrations to create as part of the HTTP APIs. Supported only for HTTP APIs.
 * @property corsConfiguration Cross-origin resource sharing (CORS) [configuration](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html). Applicable for HTTP APIs.
 * @property credentialsArn Part of _quick create_. Specifies any credentials required for the integration. Applicable for HTTP APIs.
 * @property description Description of the API. Must be less than or equal to 1024 characters in length.
 * @property disableExecuteApiEndpoint Whether clients can invoke the API by using the default `execute-api` endpoint.
 * By default, clients can invoke the API with the default `{api_id}.execute-api.{region}.amazonaws.com endpoint`.
 * To require that clients use a custom domain name to invoke the API, disable the default endpoint.
 * @property failOnWarnings Whether warnings should return an error while API Gateway is creating or updating the resource using an OpenAPI specification. Defaults to `false`. Applicable for HTTP APIs.
 * @property name Name of the API. Must be less than or equal to 128 characters in length.
 * @property protocolType API protocol. Valid values: `HTTP`, `WEBSOCKET`.
 * @property routeKey Part of _quick create_. Specifies any [route key](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-routes.html). Applicable for HTTP APIs.
 * @property routeSelectionExpression The [route selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-route-selection-expressions) for the API.
 * Defaults to `$request.method $request.path`.
 * @property tags Map of tags to assign to the API. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property target Part of _quick create_. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes.
 * For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN.
 * The type of the integration will be `HTTP_PROXY` or `AWS_PROXY`, respectively. Applicable for HTTP APIs.
 * @property version Version identifier for the API. Must be between 1 and 64 characters in length.
 */
public data class ApiArgs(
    public val apiKeySelectionExpression: Output<String>? = null,
    public val body: Output<String>? = null,
    public val corsConfiguration: Output<ApiCorsConfigurationArgs>? = null,
    public val credentialsArn: Output<String>? = null,
    public val description: Output<String>? = null,
    public val disableExecuteApiEndpoint: Output<Boolean>? = null,
    public val failOnWarnings: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val protocolType: Output<String>? = null,
    public val routeKey: Output<String>? = null,
    public val routeSelectionExpression: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val target: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.ApiArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.ApiArgs =
        com.pulumi.aws.apigatewayv2.ApiArgs.builder()
            .apiKeySelectionExpression(apiKeySelectionExpression?.applyValue({ args0 -> args0 }))
            .body(body?.applyValue({ args0 -> args0 }))
            .corsConfiguration(corsConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .credentialsArn(credentialsArn?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .disableExecuteApiEndpoint(disableExecuteApiEndpoint?.applyValue({ args0 -> args0 }))
            .failOnWarnings(failOnWarnings?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .protocolType(protocolType?.applyValue({ args0 -> args0 }))
            .routeKey(routeKey?.applyValue({ args0 -> args0 }))
            .routeSelectionExpression(routeSelectionExpression?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .target(target?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiArgs].
 */
@PulumiTagMarker
public class ApiArgsBuilder internal constructor() {
    private var apiKeySelectionExpression: Output<String>? = null

    private var body: Output<String>? = null

    private var corsConfiguration: Output<ApiCorsConfigurationArgs>? = null

    private var credentialsArn: Output<String>? = null

    private var description: Output<String>? = null

    private var disableExecuteApiEndpoint: Output<Boolean>? = null

    private var failOnWarnings: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var protocolType: Output<String>? = null

    private var routeKey: Output<String>? = null

    private var routeSelectionExpression: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var target: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value An [API key selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
     * Valid values: `$context.authorizer.usageIdentifierKey`, `$request.header.x-api-key`. Defaults to `$request.header.x-api-key`.
     * Applicable for WebSocket APIs.
     */
    @JvmName("ayqbxthumqilirqf")
    public suspend fun apiKeySelectionExpression(`value`: Output<String>) {
        this.apiKeySelectionExpression = value
    }

    /**
     * @param value An OpenAPI specification that defines the set of routes and integrations to create as part of the HTTP APIs. Supported only for HTTP APIs.
     */
    @JvmName("ljpebhbexlluhxbr")
    public suspend fun body(`value`: Output<String>) {
        this.body = value
    }

    /**
     * @param value Cross-origin resource sharing (CORS) [configuration](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html). Applicable for HTTP APIs.
     */
    @JvmName("ujwbswsibmnmoatq")
    public suspend fun corsConfiguration(`value`: Output<ApiCorsConfigurationArgs>) {
        this.corsConfiguration = value
    }

    /**
     * @param value Part of _quick create_. Specifies any credentials required for the integration. Applicable for HTTP APIs.
     */
    @JvmName("oubegxfgxrhpsgou")
    public suspend fun credentialsArn(`value`: Output<String>) {
        this.credentialsArn = value
    }

    /**
     * @param value Description of the API. Must be less than or equal to 1024 characters in length.
     */
    @JvmName("yvwsumttdrvvhjdc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether clients can invoke the API by using the default `execute-api` endpoint.
     * By default, clients can invoke the API with the default `{api_id}.execute-api.{region}.amazonaws.com endpoint`.
     * To require that clients use a custom domain name to invoke the API, disable the default endpoint.
     */
    @JvmName("fgcsdxaggawillko")
    public suspend fun disableExecuteApiEndpoint(`value`: Output<Boolean>) {
        this.disableExecuteApiEndpoint = value
    }

    /**
     * @param value Whether warnings should return an error while API Gateway is creating or updating the resource using an OpenAPI specification. Defaults to `false`. Applicable for HTTP APIs.
     */
    @JvmName("ycqgbfgrowmkopdd")
    public suspend fun failOnWarnings(`value`: Output<Boolean>) {
        this.failOnWarnings = value
    }

    /**
     * @param value Name of the API. Must be less than or equal to 128 characters in length.
     */
    @JvmName("qkopxhnegncclhvo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value API protocol. Valid values: `HTTP`, `WEBSOCKET`.
     */
    @JvmName("cyykgpnsngsjnxec")
    public suspend fun protocolType(`value`: Output<String>) {
        this.protocolType = value
    }

    /**
     * @param value Part of _quick create_. Specifies any [route key](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-routes.html). Applicable for HTTP APIs.
     */
    @JvmName("rfklpgkvpklwlgtj")
    public suspend fun routeKey(`value`: Output<String>) {
        this.routeKey = value
    }

    /**
     * @param value The [route selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-route-selection-expressions) for the API.
     * Defaults to `$request.method $request.path`.
     */
    @JvmName("uiebdoxxscitchtx")
    public suspend fun routeSelectionExpression(`value`: Output<String>) {
        this.routeSelectionExpression = value
    }

    /**
     * @param value Map of tags to assign to the API. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wuptfgoamoqhndxh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Part of _quick create_. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes.
     * For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN.
     * The type of the integration will be `HTTP_PROXY` or `AWS_PROXY`, respectively. Applicable for HTTP APIs.
     */
    @JvmName("wyhglviorrryfkqe")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value Version identifier for the API. Must be between 1 and 64 characters in length.
     */
    @JvmName("gebkxtayuwqkesgf")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value An [API key selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
     * Valid values: `$context.authorizer.usageIdentifierKey`, `$request.header.x-api-key`. Defaults to `$request.header.x-api-key`.
     * Applicable for WebSocket APIs.
     */
    @JvmName("dqnukipwsnarsduy")
    public suspend fun apiKeySelectionExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiKeySelectionExpression = mapped
    }

    /**
     * @param value An OpenAPI specification that defines the set of routes and integrations to create as part of the HTTP APIs. Supported only for HTTP APIs.
     */
    @JvmName("tixubrgbcwfruhig")
    public suspend fun body(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param value Cross-origin resource sharing (CORS) [configuration](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html). Applicable for HTTP APIs.
     */
    @JvmName("jegfhohodwequoky")
    public suspend fun corsConfiguration(`value`: ApiCorsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.corsConfiguration = mapped
    }

    /**
     * @param argument Cross-origin resource sharing (CORS) [configuration](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html). Applicable for HTTP APIs.
     */
    @JvmName("swyhcxnkyixahgnh")
    public suspend fun corsConfiguration(argument: suspend ApiCorsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ApiCorsConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.corsConfiguration = mapped
    }

    /**
     * @param value Part of _quick create_. Specifies any credentials required for the integration. Applicable for HTTP APIs.
     */
    @JvmName("qrruowlaavxvtlhx")
    public suspend fun credentialsArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentialsArn = mapped
    }

    /**
     * @param value Description of the API. Must be less than or equal to 1024 characters in length.
     */
    @JvmName("smgqtqbcwwbjemtf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether clients can invoke the API by using the default `execute-api` endpoint.
     * By default, clients can invoke the API with the default `{api_id}.execute-api.{region}.amazonaws.com endpoint`.
     * To require that clients use a custom domain name to invoke the API, disable the default endpoint.
     */
    @JvmName("ovgvultggkxacsmb")
    public suspend fun disableExecuteApiEndpoint(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableExecuteApiEndpoint = mapped
    }

    /**
     * @param value Whether warnings should return an error while API Gateway is creating or updating the resource using an OpenAPI specification. Defaults to `false`. Applicable for HTTP APIs.
     */
    @JvmName("gsimuwigtsivpvoy")
    public suspend fun failOnWarnings(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failOnWarnings = mapped
    }

    /**
     * @param value Name of the API. Must be less than or equal to 128 characters in length.
     */
    @JvmName("xwkjucvowpnlmolm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value API protocol. Valid values: `HTTP`, `WEBSOCKET`.
     */
    @JvmName("uusxckyncxaumygp")
    public suspend fun protocolType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocolType = mapped
    }

    /**
     * @param value Part of _quick create_. Specifies any [route key](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-routes.html). Applicable for HTTP APIs.
     */
    @JvmName("ugaohvlwwuhgdkou")
    public suspend fun routeKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeKey = mapped
    }

    /**
     * @param value The [route selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-route-selection-expressions) for the API.
     * Defaults to `$request.method $request.path`.
     */
    @JvmName("ielshlkrwjkpjdpx")
    public suspend fun routeSelectionExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeSelectionExpression = mapped
    }

    /**
     * @param value Map of tags to assign to the API. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tgbisovusqqsndlf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the API. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("punqhvpufkrhlehr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Part of _quick create_. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes.
     * For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN.
     * The type of the integration will be `HTTP_PROXY` or `AWS_PROXY`, respectively. Applicable for HTTP APIs.
     */
    @JvmName("uxjfpwxytsjhwddd")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param value Version identifier for the API. Must be between 1 and 64 characters in length.
     */
    @JvmName("agcsxuaqlgtndncd")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ApiArgs = ApiArgs(
        apiKeySelectionExpression = apiKeySelectionExpression,
        body = body,
        corsConfiguration = corsConfiguration,
        credentialsArn = credentialsArn,
        description = description,
        disableExecuteApiEndpoint = disableExecuteApiEndpoint,
        failOnWarnings = failOnWarnings,
        name = name,
        protocolType = protocolType,
        routeKey = routeKey,
        routeSelectionExpression = routeSelectionExpression,
        tags = tags,
        target = target,
        version = version,
    )
}
