@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ApiMapping].
 */
@PulumiTagMarker
public class ApiMappingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApiMappingArgs = ApiMappingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApiMappingArgsBuilder.() -> Unit) {
        val builder = ApiMappingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApiMapping {
        val builtJavaResource = com.pulumi.aws.apigatewayv2.ApiMapping(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ApiMapping(builtJavaResource)
    }
}

/**
 * Manages an Amazon API Gateway Version 2 API mapping.
 * More information can be found in the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html).
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apigatewayv2.ApiMapping("example", {
 *     apiId: exampleAwsApigatewayv2Api.id,
 *     domainName: exampleAwsApigatewayv2DomainName.id,
 *     stage: exampleAwsApigatewayv2Stage.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apigatewayv2.ApiMapping("example",
 *     api_id=example_aws_apigatewayv2_api["id"],
 *     domain_name=example_aws_apigatewayv2_domain_name["id"],
 *     stage=example_aws_apigatewayv2_stage["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ApiGatewayV2.ApiMapping("example", new()
 *     {
 *         ApiId = exampleAwsApigatewayv2Api.Id,
 *         DomainName = exampleAwsApigatewayv2DomainName.Id,
 *         Stage = exampleAwsApigatewayv2Stage.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigatewayv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigatewayv2.NewApiMapping(ctx, "example", &apigatewayv2.ApiMappingArgs{
 * 			ApiId:      pulumi.Any(exampleAwsApigatewayv2Api.Id),
 * 			DomainName: pulumi.Any(exampleAwsApigatewayv2DomainName.Id),
 * 			Stage:      pulumi.Any(exampleAwsApigatewayv2Stage.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.ApiMapping;
 * import com.pulumi.aws.apigatewayv2.ApiMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ApiMapping("example", ApiMappingArgs.builder()
 *             .apiId(exampleAwsApigatewayv2Api.id())
 *             .domainName(exampleAwsApigatewayv2DomainName.id())
 *             .stage(exampleAwsApigatewayv2Stage.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apigatewayv2:ApiMapping
 *     properties:
 *       apiId: ${exampleAwsApigatewayv2Api.id}
 *       domainName: ${exampleAwsApigatewayv2DomainName.id}
 *       stage: ${exampleAwsApigatewayv2Stage.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_api_mapping` using the API mapping identifier and domain name. For example:
 * ```sh
 * $ pulumi import aws:apigatewayv2/apiMapping:ApiMapping example 1122334/ws-api.example.com
 * ```
 */
public class ApiMapping internal constructor(
    override val javaResource: com.pulumi.aws.apigatewayv2.ApiMapping,
) : KotlinCustomResource(javaResource, ApiMappingMapper) {
    /**
     * API identifier.
     */
    public val apiId: Output<String>
        get() = javaResource.apiId().applyValue({ args0 -> args0 })

    /**
     * The API mapping key. Refer to [REST API](https://docs&#46;aws&#46;amazon&#46;com/apigateway/latest/developerguide/rest-api-mappings&#46;html), [HTTP API](https://docs&#46;aws&#46;amazon&#46;com/apigateway/latest/developerguide/http-api-mappings&#46;html) or [WebSocket API](https://docs.aws.amazon.com/apigateway/latest/developerguide/websocket-api-mappings.html).
     */
    public val apiMappingKey: Output<String>?
        get() = javaResource.apiMappingKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Domain name. Use the `aws.apigatewayv2.DomainName` resource to configure a domain name.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * API stage. Use the `aws.apigatewayv2.Stage` resource to configure an API stage.
     */
    public val stage: Output<String>
        get() = javaResource.stage().applyValue({ args0 -> args0 })
}

public object ApiMappingMapper : ResourceMapper<ApiMapping> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigatewayv2.ApiMapping::class == javaResource::class

    override fun map(javaResource: Resource): ApiMapping = ApiMapping(
        javaResource as
            com.pulumi.aws.apigatewayv2.ApiMapping,
    )
}

/**
 * @see [ApiMapping].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApiMapping].
 */
public suspend fun apiMapping(name: String, block: suspend ApiMappingResourceBuilder.() -> Unit): ApiMapping {
    val builder = ApiMappingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApiMapping].
 * @param name The _unique_ name of the resulting resource.
 */
public fun apiMapping(name: String): ApiMapping {
    val builder = ApiMappingResourceBuilder()
    builder.name(name)
    return builder.build()
}
