@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.kotlin.outputs.AuthorizerJwtConfiguration
import com.pulumi.aws.apigatewayv2.kotlin.outputs.AuthorizerJwtConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Authorizer].
 */
@PulumiTagMarker
public class AuthorizerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AuthorizerArgs = AuthorizerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AuthorizerArgsBuilder.() -> Unit) {
        val builder = AuthorizerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Authorizer {
        val builtJavaResource = com.pulumi.aws.apigatewayv2.Authorizer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Authorizer(builtJavaResource)
    }
}

/**
 * Manages an Amazon API Gateway Version 2 authorizer.
 * More information can be found in the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api.html).
 * ## Example Usage
 * ### Basic WebSocket API
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apigatewayv2.Authorizer("example", {
 *     apiId: exampleAwsApigatewayv2Api.id,
 *     authorizerType: "REQUEST",
 *     authorizerUri: exampleAwsLambdaFunction.invokeArn,
 *     identitySources: ["route&#46;request&#46;header&#46;Auth"],
 *     name: "example-authorizer",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apigatewayv2.Authorizer("example",
 *     api_id=example_aws_apigatewayv2_api["id"],
 *     authorizer_type="REQUEST",
 *     authorizer_uri=example_aws_lambda_function["invokeArn"],
 *     identity_sources=["route&#46;request&#46;header&#46;Auth"],
 *     name="example-authorizer")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ApiGatewayV2.Authorizer("example", new()
 *     {
 *         ApiId = exampleAwsApigatewayv2Api.Id,
 *         AuthorizerType = "REQUEST",
 *         AuthorizerUri = exampleAwsLambdaFunction.InvokeArn,
 *         IdentitySources = new[]
 *         {
 *             "route.request.header.Auth",
 *         },
 *         Name = "example-authorizer",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigatewayv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigatewayv2.NewAuthorizer(ctx, "example", &apigatewayv2.AuthorizerArgs{
 * 			ApiId:          pulumi.Any(exampleAwsApigatewayv2Api.Id),
 * 			AuthorizerType: pulumi.String("REQUEST"),
 * 			AuthorizerUri:  pulumi.Any(exampleAwsLambdaFunction.InvokeArn),
 * 			IdentitySources: pulumi.StringArray{
 * 				pulumi.String("route.request.header.Auth"),
 * 			},
 * 			Name: pulumi.String("example-authorizer"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Authorizer;
 * import com.pulumi.aws.apigatewayv2.AuthorizerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Authorizer("example", AuthorizerArgs.builder()
 *             .apiId(exampleAwsApigatewayv2Api.id())
 *             .authorizerType("REQUEST")
 *             .authorizerUri(exampleAwsLambdaFunction.invokeArn())
 *             .identitySources("route.request.header.Auth")
 *             .name("example-authorizer")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apigatewayv2:Authorizer
 *     properties:
 *       apiId: ${exampleAwsApigatewayv2Api.id}
 *       authorizerType: REQUEST
 *       authorizerUri: ${exampleAwsLambdaFunction.invokeArn}
 *       identitySources:
 *         - route.request.header.Auth
 *       name: example-authorizer
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Basic HTTP API
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apigatewayv2.Authorizer("example", {
 *     apiId: exampleAwsApigatewayv2Api.id,
 *     authorizerType: "REQUEST",
 *     authorizerUri: exampleAwsLambdaFunction.invokeArn,
 *     identitySources: ["$request&#46;header&#46;Authorization"],
 *     name: "example-authorizer",
 *     authorizerPayloadFormatVersion: "2.0",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apigatewayv2.Authorizer("example",
 *     api_id=example_aws_apigatewayv2_api["id"],
 *     authorizer_type="REQUEST",
 *     authorizer_uri=example_aws_lambda_function["invokeArn"],
 *     identity_sources=["$request&#46;header&#46;Authorization"],
 *     name="example-authorizer",
 *     authorizer_payload_format_version="2.0")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ApiGatewayV2.Authorizer("example", new()
 *     {
 *         ApiId = exampleAwsApigatewayv2Api.Id,
 *         AuthorizerType = "REQUEST",
 *         AuthorizerUri = exampleAwsLambdaFunction.InvokeArn,
 *         IdentitySources = new[]
 *         {
 *             "$request.header.Authorization",
 *         },
 *         Name = "example-authorizer",
 *         AuthorizerPayloadFormatVersion = "2.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigatewayv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigatewayv2.NewAuthorizer(ctx, "example", &apigatewayv2.AuthorizerArgs{
 * 			ApiId:          pulumi.Any(exampleAwsApigatewayv2Api.Id),
 * 			AuthorizerType: pulumi.String("REQUEST"),
 * 			AuthorizerUri:  pulumi.Any(exampleAwsLambdaFunction.InvokeArn),
 * 			IdentitySources: pulumi.StringArray{
 * 				pulumi.String("$request.header.Authorization"),
 * 			},
 * 			Name:                           pulumi.String("example-authorizer"),
 * 			AuthorizerPayloadFormatVersion: pulumi.String("2.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Authorizer;
 * import com.pulumi.aws.apigatewayv2.AuthorizerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Authorizer("example", AuthorizerArgs.builder()
 *             .apiId(exampleAwsApigatewayv2Api.id())
 *             .authorizerType("REQUEST")
 *             .authorizerUri(exampleAwsLambdaFunction.invokeArn())
 *             .identitySources("$request.header.Authorization")
 *             .name("example-authorizer")
 *             .authorizerPayloadFormatVersion("2.0")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apigatewayv2:Authorizer
 *     properties:
 *       apiId: ${exampleAwsApigatewayv2Api.id}
 *       authorizerType: REQUEST
 *       authorizerUri: ${exampleAwsLambdaFunction.invokeArn}
 *       identitySources:
 *         - $request.header.Authorization
 *       name: example-authorizer
 *       authorizerPayloadFormatVersion: '2.0'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_authorizer` using the API identifier and authorizer identifier. For example:
 * ```sh
 * $ pulumi import aws:apigatewayv2/authorizer:Authorizer example aabbccddee/1122334
 * ```
 */
public class Authorizer internal constructor(
    override val javaResource: com.pulumi.aws.apigatewayv2.Authorizer,
) : KotlinCustomResource(javaResource, AuthorizerMapper) {
    /**
     * API identifier.
     */
    public val apiId: Output<String>
        get() = javaResource.apiId().applyValue({ args0 -> args0 })

    /**
     * Required credentials as an IAM role for API Gateway to invoke the authorizer.
     * Supported only for `REQUEST` authorizers.
     */
    public val authorizerCredentialsArn: Output<String>?
        get() = javaResource.authorizerCredentialsArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers.
     * Valid values: `1.0`, `2.0`.
     */
    public val authorizerPayloadFormatVersion: Output<String>?
        get() = javaResource.authorizerPayloadFormatVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled.
     * If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Defaults to `300`.
     * Supported only for HTTP API Lambda authorizers.
     */
    public val authorizerResultTtlInSeconds: Output<Int>
        get() = javaResource.authorizerResultTtlInSeconds().applyValue({ args0 -> args0 })

    /**
     * Authorizer type. Valid values: `JWT`, `REQUEST`.
     * Specify `REQUEST` for a Lambda function using incoming request parameters.
     * For HTTP APIs, specify `JWT` to use JSON Web Tokens.
     */
    public val authorizerType: Output<String>
        get() = javaResource.authorizerType().applyValue({ args0 -> args0 })

    /**
     * Authorizer's Uniform Resource Identifier (URI).
     * For `REQUEST` authorizers this must be a well-formed Lambda function URI, such as the `invoke_arn` attribute of the `aws.lambda.Function` resource.
     * Supported only for `REQUEST` authorizers. Must be between 1 and 2048 characters in length.
     */
    public val authorizerUri: Output<String>?
        get() = javaResource.authorizerUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy.
     * Supported only for HTTP APIs.
     */
    public val enableSimpleResponses: Output<Boolean>?
        get() = javaResource.enableSimpleResponses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identity sources for which authorization is requested.
     * For `REQUEST` authorizers the value is a list of one or more mapping expressions of the specified request parameters.
     * For `JWT` authorizers the single entry specifies where to extract the JSON Web Token (JWT) from inbound requests.
     */
    public val identitySources: Output<List<String>>?
        get() = javaResource.identitySources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Configuration of a JWT authorizer. Required for the `JWT` authorizer type.
     * Supported only for HTTP APIs.
     */
    public val jwtConfiguration: Output<AuthorizerJwtConfiguration>?
        get() = javaResource.jwtConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Name of the authorizer. Must be between 1 and 128 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object AuthorizerMapper : ResourceMapper<Authorizer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigatewayv2.Authorizer::class == javaResource::class

    override fun map(javaResource: Resource): Authorizer = Authorizer(
        javaResource as
            com.pulumi.aws.apigatewayv2.Authorizer,
    )
}

/**
 * @see [Authorizer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Authorizer].
 */
public suspend fun authorizer(name: String, block: suspend AuthorizerResourceBuilder.() -> Unit): Authorizer {
    val builder = AuthorizerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Authorizer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun authorizer(name: String): Authorizer {
    val builder = AuthorizerResourceBuilder()
    builder.name(name)
    return builder.build()
}
