@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.DomainNameArgs.builder
import com.pulumi.aws.apigatewayv2.kotlin.inputs.DomainNameDomainNameConfigurationArgs
import com.pulumi.aws.apigatewayv2.kotlin.inputs.DomainNameDomainNameConfigurationArgsBuilder
import com.pulumi.aws.apigatewayv2.kotlin.inputs.DomainNameMutualTlsAuthenticationArgs
import com.pulumi.aws.apigatewayv2.kotlin.inputs.DomainNameMutualTlsAuthenticationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Amazon API Gateway Version 2 domain name.
 * More information can be found in the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html).
 * > **Note:** This resource establishes ownership of and the TLS settings for
 * a particular domain name. An API stage can be associated with the domain name using the `aws.apigatewayv2.ApiMapping` resource.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apigatewayv2.DomainName("example", {
 *     domainName: "ws-api.example.com",
 *     domainNameConfiguration: {
 *         certificateArn: exampleAwsAcmCertificate.arn,
 *         endpointType: "REGIONAL",
 *         securityPolicy: "TLS_1_2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apigatewayv2.DomainName("example",
 *     domain_name="ws-api.example.com",
 *     domain_name_configuration={
 *         "certificate_arn": example_aws_acm_certificate["arn"],
 *         "endpoint_type": "REGIONAL",
 *         "security_policy": "TLS_1_2",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ApiGatewayV2.DomainName("example", new()
 *     {
 *         Domain = "ws-api.example.com",
 *         DomainNameConfiguration = new Aws.ApiGatewayV2.Inputs.DomainNameDomainNameConfigurationArgs
 *         {
 *             CertificateArn = exampleAwsAcmCertificate.Arn,
 *             EndpointType = "REGIONAL",
 *             SecurityPolicy = "TLS_1_2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigatewayv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigatewayv2.NewDomainName(ctx, "example", &apigatewayv2.DomainNameArgs{
 * 			DomainName: pulumi.String("ws-api.example.com"),
 * 			DomainNameConfiguration: &apigatewayv2.DomainNameDomainNameConfigurationArgs{
 * 				CertificateArn: pulumi.Any(exampleAwsAcmCertificate.Arn),
 * 				EndpointType:   pulumi.String("REGIONAL"),
 * 				SecurityPolicy: pulumi.String("TLS_1_2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.DomainName;
 * import com.pulumi.aws.apigatewayv2.DomainNameArgs;
 * import com.pulumi.aws.apigatewayv2.inputs.DomainNameDomainNameConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DomainName("example", DomainNameArgs.builder()
 *             .domainName("ws-api.example.com")
 *             .domainNameConfiguration(DomainNameDomainNameConfigurationArgs.builder()
 *                 .certificateArn(exampleAwsAcmCertificate.arn())
 *                 .endpointType("REGIONAL")
 *                 .securityPolicy("TLS_1_2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apigatewayv2:DomainName
 *     properties:
 *       domainName: ws-api.example.com
 *       domainNameConfiguration:
 *         certificateArn: ${exampleAwsAcmCertificate.arn}
 *         endpointType: REGIONAL
 *         securityPolicy: TLS_1_2
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Associated Route 53 Resource Record
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apigatewayv2.DomainName("example", {
 *     domainName: "http-api.example.com",
 *     domainNameConfiguration: {
 *         certificateArn: exampleAwsAcmCertificate.arn,
 *         endpointType: "REGIONAL",
 *         securityPolicy: "TLS_1_2",
 *     },
 * });
 * const exampleRecord = new aws.route53.Record("example", {
 *     name: example.domainName,
 *     type: aws.route53.RecordType.A,
 *     zoneId: exampleAwsRoute53Zone.zoneId,
 *     aliases: [{
 *         name: example.domainNameConfiguration.apply(domainNameConfiguration => domainNameConfiguration.targetDomainName),
 *         zoneId: example.domainNameConfiguration.apply(domainNameConfiguration => domainNameConfiguration.hostedZoneId),
 *         evaluateTargetHealth: false,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apigatewayv2.DomainName("example",
 *     domain_name="http-api.example.com",
 *     domain_name_configuration={
 *         "certificate_arn": example_aws_acm_certificate["arn"],
 *         "endpoint_type": "REGIONAL",
 *         "security_policy": "TLS_1_2",
 *     })
 * example_record = aws.route53.Record("example",
 *     name=example.domain_name,
 *     type=aws.route53.RecordType.A,
 *     zone_id=example_aws_route53_zone["zoneId"],
 *     aliases=[{
 *         "name": example.domain_name_configuration.target_domain_name,
 *         "zone_id": example.domain_name_configuration.hosted_zone_id,
 *         "evaluate_target_health": False,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ApiGatewayV2.DomainName("example", new()
 *     {
 *         Domain = "http-api.example.com",
 *         DomainNameConfiguration = new Aws.ApiGatewayV2.Inputs.DomainNameDomainNameConfigurationArgs
 *         {
 *             CertificateArn = exampleAwsAcmCertificate.Arn,
 *             EndpointType = "REGIONAL",
 *             SecurityPolicy = "TLS_1_2",
 *         },
 *     });
 *     var exampleRecord = new Aws.Route53.Record("example", new()
 *     {
 *         Name = example.Domain,
 *         Type = Aws.Route53.RecordType.A,
 *         ZoneId = exampleAwsRoute53Zone.ZoneId,
 *         Aliases = new[]
 *         {
 *             new Aws.Route53.Inputs.RecordAliasArgs
 *             {
 *                 Name = example.DomainNameConfiguration.Apply(domainNameConfiguration => domainNameConfiguration.TargetDomainName),
 *                 ZoneId = example.DomainNameConfiguration.Apply(domainNameConfiguration => domainNameConfiguration.HostedZoneId),
 *                 EvaluateTargetHealth = false,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigatewayv2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := apigatewayv2.NewDomainName(ctx, "example", &apigatewayv2.DomainNameArgs{
 * 			DomainName: pulumi.String("http-api.example.com"),
 * 			DomainNameConfiguration: &apigatewayv2.DomainNameDomainNameConfigurationArgs{
 * 				CertificateArn: pulumi.Any(exampleAwsAcmCertificate.Arn),
 * 				EndpointType:   pulumi.String("REGIONAL"),
 * 				SecurityPolicy: pulumi.String("TLS_1_2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = route53.NewRecord(ctx, "example", &route53.RecordArgs{
 * 			Name:   example.DomainName,
 * 			Type:   pulumi.String(route53.RecordTypeA),
 * 			ZoneId: pulumi.Any(exampleAwsRoute53Zone.ZoneId),
 * 			Aliases: route53.RecordAliasArray{
 * 				&route53.RecordAliasArgs{
 * 					Name: example.DomainNameConfiguration.ApplyT(func(domainNameConfiguration apigatewayv2.DomainNameDomainNameConfiguration) (*string, error) {
 * 						return &domainNameConfiguration.TargetDomainName, nil
 * 					}).(pulumi.StringPtrOutput),
 * 					ZoneId: example.DomainNameConfiguration.ApplyT(func(domainNameConfiguration apigatewayv2.DomainNameDomainNameConfiguration) (*string, error) {
 * 						return &domainNameConfiguration.HostedZoneId, nil
 * 					}).(pulumi.StringPtrOutput),
 * 					EvaluateTargetHealth: pulumi.Bool(false),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.DomainName;
 * import com.pulumi.aws.apigatewayv2.DomainNameArgs;
 * import com.pulumi.aws.apigatewayv2.inputs.DomainNameDomainNameConfigurationArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DomainName("example", DomainNameArgs.builder()
 *             .domainName("http-api.example.com")
 *             .domainNameConfiguration(DomainNameDomainNameConfigurationArgs.builder()
 *                 .certificateArn(exampleAwsAcmCertificate.arn())
 *                 .endpointType("REGIONAL")
 *                 .securityPolicy("TLS_1_2")
 *                 .build())
 *             .build());
 *         var exampleRecord = new Record("exampleRecord", RecordArgs.builder()
 *             .name(example.domainName())
 *             .type("A")
 *             .zoneId(exampleAwsRoute53Zone.zoneId())
 *             .aliases(RecordAliasArgs.builder()
 *                 .name(example.domainNameConfiguration().applyValue(domainNameConfiguration -> domainNameConfiguration.targetDomainName()))
 *                 .zoneId(example.domainNameConfiguration().applyValue(domainNameConfiguration -> domainNameConfiguration.hostedZoneId()))
 *                 .evaluateTargetHealth(false)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apigatewayv2:DomainName
 *     properties:
 *       domainName: http-api.example.com
 *       domainNameConfiguration:
 *         certificateArn: ${exampleAwsAcmCertificate.arn}
 *         endpointType: REGIONAL
 *         securityPolicy: TLS_1_2
 *   exampleRecord:
 *     type: aws:route53:Record
 *     name: example
 *     properties:
 *       name: ${example.domainName}
 *       type: A
 *       zoneId: ${exampleAwsRoute53Zone.zoneId}
 *       aliases:
 *         - name: ${example.domainNameConfiguration.targetDomainName}
 *           zoneId: ${example.domainNameConfiguration.hostedZoneId}
 *           evaluateTargetHealth: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_domain_name` using the domain name. For example:
 * ```sh
 * $ pulumi import aws:apigatewayv2/domainName:DomainName example ws-api.example.com
 * ```
 * @property domainName Domain name. Must be between 1 and 512 characters in length.
 * @property domainNameConfiguration Domain name configuration. See below.
 * @property mutualTlsAuthentication Mutual TLS authentication configuration for the domain name.
 * @property tags Map of tags to assign to the domain name. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class DomainNameArgs(
    public val domainName: Output<String>? = null,
    public val domainNameConfiguration: Output<DomainNameDomainNameConfigurationArgs>? = null,
    public val mutualTlsAuthentication: Output<DomainNameMutualTlsAuthenticationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.DomainNameArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.DomainNameArgs =
        com.pulumi.aws.apigatewayv2.DomainNameArgs.builder()
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .domainNameConfiguration(
                domainNameConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .mutualTlsAuthentication(
                mutualTlsAuthentication?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DomainNameArgs].
 */
@PulumiTagMarker
public class DomainNameArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var domainNameConfiguration: Output<DomainNameDomainNameConfigurationArgs>? = null

    private var mutualTlsAuthentication: Output<DomainNameMutualTlsAuthenticationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Domain name. Must be between 1 and 512 characters in length.
     */
    @JvmName("flvqobtpdixqywhg")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Domain name configuration. See below.
     */
    @JvmName("eshqtbcjcirffnkr")
    public suspend fun domainNameConfiguration(`value`: Output<DomainNameDomainNameConfigurationArgs>) {
        this.domainNameConfiguration = value
    }

    /**
     * @param value Mutual TLS authentication configuration for the domain name.
     */
    @JvmName("fvbkixwnxgquukhn")
    public suspend fun mutualTlsAuthentication(`value`: Output<DomainNameMutualTlsAuthenticationArgs>) {
        this.mutualTlsAuthentication = value
    }

    /**
     * @param value Map of tags to assign to the domain name. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("idnvawacuhualewn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Domain name. Must be between 1 and 512 characters in length.
     */
    @JvmName("moetlgqyjktftqnx")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Domain name configuration. See below.
     */
    @JvmName("ttjwarwvsruiqgxc")
    public suspend fun domainNameConfiguration(`value`: DomainNameDomainNameConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainNameConfiguration = mapped
    }

    /**
     * @param argument Domain name configuration. See below.
     */
    @JvmName("wlebxrwcugsvbbkc")
    public suspend fun domainNameConfiguration(argument: suspend DomainNameDomainNameConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DomainNameDomainNameConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.domainNameConfiguration = mapped
    }

    /**
     * @param value Mutual TLS authentication configuration for the domain name.
     */
    @JvmName("dpstcviawkwmxesb")
    public suspend fun mutualTlsAuthentication(`value`: DomainNameMutualTlsAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mutualTlsAuthentication = mapped
    }

    /**
     * @param argument Mutual TLS authentication configuration for the domain name.
     */
    @JvmName("dljutecslcqtnrjb")
    public suspend fun mutualTlsAuthentication(argument: suspend DomainNameMutualTlsAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = DomainNameMutualTlsAuthenticationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.mutualTlsAuthentication = mapped
    }

    /**
     * @param value Map of tags to assign to the domain name. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ocbrftblmbpktfgf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the domain name. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pjaoibithyciyigt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DomainNameArgs = DomainNameArgs(
        domainName = domainName,
        domainNameConfiguration = domainNameConfiguration,
        mutualTlsAuthentication = mutualTlsAuthentication,
        tags = tags,
    )
}
