@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [IntegrationResponse].
 */
@PulumiTagMarker
public class IntegrationResponseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationResponseArgs = IntegrationResponseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationResponseArgsBuilder.() -> Unit) {
        val builder = IntegrationResponseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IntegrationResponse {
        val builtJavaResource = com.pulumi.aws.apigatewayv2.IntegrationResponse(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IntegrationResponse(builtJavaResource)
    }
}

/**
 * Manages an Amazon API Gateway Version 2 integration response.
 * More information can be found in the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api.html).
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apigatewayv2.IntegrationResponse("example", {
 *     apiId: exampleAwsApigatewayv2Api.id,
 *     integrationId: exampleAwsApigatewayv2Integration.id,
 *     integrationResponseKey: "/200/",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apigatewayv2.IntegrationResponse("example",
 *     api_id=example_aws_apigatewayv2_api["id"],
 *     integration_id=example_aws_apigatewayv2_integration["id"],
 *     integration_response_key="/200/")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ApiGatewayV2.IntegrationResponse("example", new()
 *     {
 *         ApiId = exampleAwsApigatewayv2Api.Id,
 *         IntegrationId = exampleAwsApigatewayv2Integration.Id,
 *         IntegrationResponseKey = "/200/",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigatewayv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigatewayv2.NewIntegrationResponse(ctx, "example", &apigatewayv2.IntegrationResponseArgs{
 * 			ApiId:                  pulumi.Any(exampleAwsApigatewayv2Api.Id),
 * 			IntegrationId:          pulumi.Any(exampleAwsApigatewayv2Integration.Id),
 * 			IntegrationResponseKey: pulumi.String("/200/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.IntegrationResponse;
 * import com.pulumi.aws.apigatewayv2.IntegrationResponseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new IntegrationResponse("example", IntegrationResponseArgs.builder()
 *             .apiId(exampleAwsApigatewayv2Api.id())
 *             .integrationId(exampleAwsApigatewayv2Integration.id())
 *             .integrationResponseKey("/200/")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apigatewayv2:IntegrationResponse
 *     properties:
 *       apiId: ${exampleAwsApigatewayv2Api.id}
 *       integrationId: ${exampleAwsApigatewayv2Integration.id}
 *       integrationResponseKey: /200/
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_integration_response` using the API identifier, integration identifier and integration response identifier. For example:
 * ```sh
 * $ pulumi import aws:apigatewayv2/integrationResponse:IntegrationResponse example aabbccddee/1122334/998877
 * ```
 */
public class IntegrationResponse internal constructor(
    override val javaResource: com.pulumi.aws.apigatewayv2.IntegrationResponse,
) : KotlinCustomResource(javaResource, IntegrationResponseMapper) {
    /**
     * API identifier.
     */
    public val apiId: Output<String>
        get() = javaResource.apiId().applyValue({ args0 -> args0 })

    /**
     * How to handle response payload content type conversions. Valid values: `CONVERT_TO_BINARY`, `CONVERT_TO_TEXT`.
     */
    public val contentHandlingStrategy: Output<String>?
        get() = javaResource.contentHandlingStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identifier of the `aws.apigatewayv2.Integration`.
     */
    public val integrationId: Output<String>
        get() = javaResource.integrationId().applyValue({ args0 -> args0 })

    /**
     * Integration response key.
     */
    public val integrationResponseKey: Output<String>
        get() = javaResource.integrationResponseKey().applyValue({ args0 -> args0 })

    /**
     * Map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client.
     */
    public val responseTemplates: Output<Map<String, String>>?
        get() = javaResource.responseTemplates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The [template selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-template-selection-expressions) for the integration response.
     */
    public val templateSelectionExpression: Output<String>?
        get() = javaResource.templateSelectionExpression().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object IntegrationResponseMapper : ResourceMapper<IntegrationResponse> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigatewayv2.IntegrationResponse::class == javaResource::class

    override fun map(javaResource: Resource): IntegrationResponse = IntegrationResponse(
        javaResource
            as com.pulumi.aws.apigatewayv2.IntegrationResponse,
    )
}

/**
 * @see [IntegrationResponse].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IntegrationResponse].
 */
public suspend fun integrationResponse(
    name: String,
    block: suspend IntegrationResponseResourceBuilder.() -> Unit,
): IntegrationResponse {
    val builder = IntegrationResponseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IntegrationResponse].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integrationResponse(name: String): IntegrationResponse {
    val builder = IntegrationResponseResourceBuilder()
    builder.name(name)
    return builder.build()
}
