@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.IntegrationResponseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Amazon API Gateway Version 2 integration response.
 * More information can be found in the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api.html).
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apigatewayv2.IntegrationResponse("example", {
 *     apiId: exampleAwsApigatewayv2Api.id,
 *     integrationId: exampleAwsApigatewayv2Integration.id,
 *     integrationResponseKey: "/200/",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apigatewayv2.IntegrationResponse("example",
 *     api_id=example_aws_apigatewayv2_api["id"],
 *     integration_id=example_aws_apigatewayv2_integration["id"],
 *     integration_response_key="/200/")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ApiGatewayV2.IntegrationResponse("example", new()
 *     {
 *         ApiId = exampleAwsApigatewayv2Api.Id,
 *         IntegrationId = exampleAwsApigatewayv2Integration.Id,
 *         IntegrationResponseKey = "/200/",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigatewayv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigatewayv2.NewIntegrationResponse(ctx, "example", &apigatewayv2.IntegrationResponseArgs{
 * 			ApiId:                  pulumi.Any(exampleAwsApigatewayv2Api.Id),
 * 			IntegrationId:          pulumi.Any(exampleAwsApigatewayv2Integration.Id),
 * 			IntegrationResponseKey: pulumi.String("/200/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.IntegrationResponse;
 * import com.pulumi.aws.apigatewayv2.IntegrationResponseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new IntegrationResponse("example", IntegrationResponseArgs.builder()
 *             .apiId(exampleAwsApigatewayv2Api.id())
 *             .integrationId(exampleAwsApigatewayv2Integration.id())
 *             .integrationResponseKey("/200/")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apigatewayv2:IntegrationResponse
 *     properties:
 *       apiId: ${exampleAwsApigatewayv2Api.id}
 *       integrationId: ${exampleAwsApigatewayv2Integration.id}
 *       integrationResponseKey: /200/
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_integration_response` using the API identifier, integration identifier and integration response identifier. For example:
 * ```sh
 * $ pulumi import aws:apigatewayv2/integrationResponse:IntegrationResponse example aabbccddee/1122334/998877
 * ```
 * @property apiId API identifier.
 * @property contentHandlingStrategy How to handle response payload content type conversions. Valid values: `CONVERT_TO_BINARY`, `CONVERT_TO_TEXT`.
 * @property integrationId Identifier of the `aws.apigatewayv2.Integration`.
 * @property integrationResponseKey Integration response key.
 * @property responseTemplates Map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client.
 * @property templateSelectionExpression The [template selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-template-selection-expressions) for the integration response.
 */
public data class IntegrationResponseArgs(
    public val apiId: Output<String>? = null,
    public val contentHandlingStrategy: Output<String>? = null,
    public val integrationId: Output<String>? = null,
    public val integrationResponseKey: Output<String>? = null,
    public val responseTemplates: Output<Map<String, String>>? = null,
    public val templateSelectionExpression: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.IntegrationResponseArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.IntegrationResponseArgs =
        com.pulumi.aws.apigatewayv2.IntegrationResponseArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .contentHandlingStrategy(contentHandlingStrategy?.applyValue({ args0 -> args0 }))
            .integrationId(integrationId?.applyValue({ args0 -> args0 }))
            .integrationResponseKey(integrationResponseKey?.applyValue({ args0 -> args0 }))
            .responseTemplates(
                responseTemplates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .templateSelectionExpression(templateSelectionExpression?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntegrationResponseArgs].
 */
@PulumiTagMarker
public class IntegrationResponseArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var contentHandlingStrategy: Output<String>? = null

    private var integrationId: Output<String>? = null

    private var integrationResponseKey: Output<String>? = null

    private var responseTemplates: Output<Map<String, String>>? = null

    private var templateSelectionExpression: Output<String>? = null

    /**
     * @param value API identifier.
     */
    @JvmName("eogejmxfwgdkeisx")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value How to handle response payload content type conversions. Valid values: `CONVERT_TO_BINARY`, `CONVERT_TO_TEXT`.
     */
    @JvmName("mgouherrunluxlgf")
    public suspend fun contentHandlingStrategy(`value`: Output<String>) {
        this.contentHandlingStrategy = value
    }

    /**
     * @param value Identifier of the `aws.apigatewayv2.Integration`.
     */
    @JvmName("jhetfmftpyqjyeys")
    public suspend fun integrationId(`value`: Output<String>) {
        this.integrationId = value
    }

    /**
     * @param value Integration response key.
     */
    @JvmName("vvvxodsnnfgplgux")
    public suspend fun integrationResponseKey(`value`: Output<String>) {
        this.integrationResponseKey = value
    }

    /**
     * @param value Map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client.
     */
    @JvmName("qkdscnkexrcwjfvv")
    public suspend fun responseTemplates(`value`: Output<Map<String, String>>) {
        this.responseTemplates = value
    }

    /**
     * @param value The [template selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-template-selection-expressions) for the integration response.
     */
    @JvmName("bfituhsywmadldlu")
    public suspend fun templateSelectionExpression(`value`: Output<String>) {
        this.templateSelectionExpression = value
    }

    /**
     * @param value API identifier.
     */
    @JvmName("earyvrgbppxtbhxj")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value How to handle response payload content type conversions. Valid values: `CONVERT_TO_BINARY`, `CONVERT_TO_TEXT`.
     */
    @JvmName("wpkwbvroxdkbtbgx")
    public suspend fun contentHandlingStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentHandlingStrategy = mapped
    }

    /**
     * @param value Identifier of the `aws.apigatewayv2.Integration`.
     */
    @JvmName("vbngqkjptyaksbba")
    public suspend fun integrationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationId = mapped
    }

    /**
     * @param value Integration response key.
     */
    @JvmName("kmfvlnlgmoyodmvq")
    public suspend fun integrationResponseKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationResponseKey = mapped
    }

    /**
     * @param value Map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client.
     */
    @JvmName("ialgawwhplrbcqia")
    public suspend fun responseTemplates(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseTemplates = mapped
    }

    /**
     * @param values Map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client.
     */
    @JvmName("tkirxitnynpadyhw")
    public fun responseTemplates(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responseTemplates = mapped
    }

    /**
     * @param value The [template selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-template-selection-expressions) for the integration response.
     */
    @JvmName("gqukpwchmhmirokh")
    public suspend fun templateSelectionExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateSelectionExpression = mapped
    }

    internal fun build(): IntegrationResponseArgs = IntegrationResponseArgs(
        apiId = apiId,
        contentHandlingStrategy = contentHandlingStrategy,
        integrationId = integrationId,
        integrationResponseKey = integrationResponseKey,
        responseTemplates = responseTemplates,
        templateSelectionExpression = templateSelectionExpression,
    )
}
