@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Model].
 */
@PulumiTagMarker
public class ModelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ModelArgs = ModelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ModelArgsBuilder.() -> Unit) {
        val builder = ModelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Model {
        val builtJavaResource = com.pulumi.aws.apigatewayv2.Model(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Model(builtJavaResource)
    }
}

/**
 * Manages an Amazon API Gateway Version 2 [model](https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html#models-mappings-models).
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apigatewayv2.Model("example", {
 *     apiId: exampleAwsApigatewayv2Api.id,
 *     contentType: "application/json",
 *     name: "example",
 *     schema: JSON.stringify({
 *         $schema: "http://json-schema.org/draft-04/schema#",
 *         title: "ExampleModel",
 *         type: "object",
 *         properties: {
 *             id: {
 *                 type: "string",
 *             },
 *         },
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.apigatewayv2.Model("example",
 *     api_id=example_aws_apigatewayv2_api["id"],
 *     content_type="application/json",
 *     name="example",
 *     schema=json.dumps({
 *         "$schema": "http://json-schema.org/draft-04/schema#",
 *         "title": "ExampleModel",
 *         "type": "object",
 *         "properties": {
 *             "id": {
 *                 "type": "string",
 *             },
 *         },
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ApiGatewayV2.Model("example", new()
 *     {
 *         ApiId = exampleAwsApigatewayv2Api.Id,
 *         ContentType = "application/json",
 *         Name = "example",
 *         Schema = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["$schema"] = "http://json-schema.org/draft-04/schema#",
 *             ["title"] = "ExampleModel",
 *             ["type"] = "object",
 *             ["properties"] = new Dictionary<string, object?>
 *             {
 *                 ["id"] = new Dictionary<string, object?>
 *                 {
 *                     ["type"] = "string",
 *                 },
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigatewayv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"$schema": "http://json-schema.org/draft-04/schema#",
 * 			"title":   "ExampleModel",
 * 			"type":    "object",
 * 			"properties": map[string]interface{}{
 * 				"id": map[string]interface{}{
 * 					"type": "string",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = apigatewayv2.NewModel(ctx, "example", &apigatewayv2.ModelArgs{
 * 			ApiId:       pulumi.Any(exampleAwsApigatewayv2Api.Id),
 * 			ContentType: pulumi.String("application/json"),
 * 			Name:        pulumi.String("example"),
 * 			Schema:      pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Model;
 * import com.pulumi.aws.apigatewayv2.ModelArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Model("example", ModelArgs.builder()
 *             .apiId(exampleAwsApigatewayv2Api.id())
 *             .contentType("application/json")
 *             .name("example")
 *             .schema(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("$schema", "http://json-schema.org/draft-04/schema#"),
 *                     jsonProperty("title", "ExampleModel"),
 *                     jsonProperty("type", "object"),
 *                     jsonProperty("properties", jsonObject(
 *                         jsonProperty("id", jsonObject(
 *                             jsonProperty("type", "string")
 *                         ))
 *                     ))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apigatewayv2:Model
 *     properties:
 *       apiId: ${exampleAwsApigatewayv2Api.id}
 *       contentType: application/json
 *       name: example
 *       schema:
 *         fn::toJSON:
 *           $schema: http://json-schema.org/draft-04/schema#
 *           title: ExampleModel
 *           type: object
 *           properties:
 *             id:
 *               type: string
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_model` using the API identifier and model identifier. For example:
 * ```sh
 * $ pulumi import aws:apigatewayv2/model:Model example aabbccddee/1122334
 * ```
 */
public class Model internal constructor(
    override val javaResource: com.pulumi.aws.apigatewayv2.Model,
) : KotlinCustomResource(javaResource, ModelMapper) {
    /**
     * API identifier.
     */
    public val apiId: Output<String>
        get() = javaResource.apiId().applyValue({ args0 -> args0 })

    /**
     * The content-type for the model, for example, `application/json`. Must be between 1 and 256 characters in length.
     */
    public val contentType: Output<String>
        get() = javaResource.contentType().applyValue({ args0 -> args0 })

    /**
     * Description of the model. Must be between 1 and 128 characters in length.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the model. Must be alphanumeric. Must be between 1 and 128 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Schema for the model. This should be a [JSON schema draft 4](https://tools.ietf.org/html/draft-zyp-json-schema-04) model. Must be less than or equal to 32768 characters in length.
     */
    public val schema: Output<String>
        get() = javaResource.schema().applyValue({ args0 -> args0 })
}

public object ModelMapper : ResourceMapper<Model> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigatewayv2.Model::class == javaResource::class

    override fun map(javaResource: Resource): Model = Model(
        javaResource as
            com.pulumi.aws.apigatewayv2.Model,
    )
}

/**
 * @see [Model].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Model].
 */
public suspend fun model(name: String, block: suspend ModelResourceBuilder.() -> Unit): Model {
    val builder = ModelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Model].
 * @param name The _unique_ name of the resulting resource.
 */
public fun model(name: String): Model {
    val builder = ModelResourceBuilder()
    builder.name(name)
    return builder.build()
}
