@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.ModelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an Amazon API Gateway Version 2 [model](https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html#models-mappings-models).
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apigatewayv2.Model("example", {
 *     apiId: exampleAwsApigatewayv2Api.id,
 *     contentType: "application/json",
 *     name: "example",
 *     schema: JSON.stringify({
 *         $schema: "http://json-schema.org/draft-04/schema#",
 *         title: "ExampleModel",
 *         type: "object",
 *         properties: {
 *             id: {
 *                 type: "string",
 *             },
 *         },
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.apigatewayv2.Model("example",
 *     api_id=example_aws_apigatewayv2_api["id"],
 *     content_type="application/json",
 *     name="example",
 *     schema=json.dumps({
 *         "$schema": "http://json-schema.org/draft-04/schema#",
 *         "title": "ExampleModel",
 *         "type": "object",
 *         "properties": {
 *             "id": {
 *                 "type": "string",
 *             },
 *         },
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ApiGatewayV2.Model("example", new()
 *     {
 *         ApiId = exampleAwsApigatewayv2Api.Id,
 *         ContentType = "application/json",
 *         Name = "example",
 *         Schema = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["$schema"] = "http://json-schema.org/draft-04/schema#",
 *             ["title"] = "ExampleModel",
 *             ["type"] = "object",
 *             ["properties"] = new Dictionary<string, object?>
 *             {
 *                 ["id"] = new Dictionary<string, object?>
 *                 {
 *                     ["type"] = "string",
 *                 },
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigatewayv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"$schema": "http://json-schema.org/draft-04/schema#",
 * 			"title":   "ExampleModel",
 * 			"type":    "object",
 * 			"properties": map[string]interface{}{
 * 				"id": map[string]interface{}{
 * 					"type": "string",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = apigatewayv2.NewModel(ctx, "example", &apigatewayv2.ModelArgs{
 * 			ApiId:       pulumi.Any(exampleAwsApigatewayv2Api.Id),
 * 			ContentType: pulumi.String("application/json"),
 * 			Name:        pulumi.String("example"),
 * 			Schema:      pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Model;
 * import com.pulumi.aws.apigatewayv2.ModelArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Model("example", ModelArgs.builder()
 *             .apiId(exampleAwsApigatewayv2Api.id())
 *             .contentType("application/json")
 *             .name("example")
 *             .schema(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("$schema", "http://json-schema.org/draft-04/schema#"),
 *                     jsonProperty("title", "ExampleModel"),
 *                     jsonProperty("type", "object"),
 *                     jsonProperty("properties", jsonObject(
 *                         jsonProperty("id", jsonObject(
 *                             jsonProperty("type", "string")
 *                         ))
 *                     ))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apigatewayv2:Model
 *     properties:
 *       apiId: ${exampleAwsApigatewayv2Api.id}
 *       contentType: application/json
 *       name: example
 *       schema:
 *         fn::toJSON:
 *           $schema: http://json-schema.org/draft-04/schema#
 *           title: ExampleModel
 *           type: object
 *           properties:
 *             id:
 *               type: string
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_model` using the API identifier and model identifier. For example:
 * ```sh
 * $ pulumi import aws:apigatewayv2/model:Model example aabbccddee/1122334
 * ```
 * @property apiId API identifier.
 * @property contentType The content-type for the model, for example, `application/json`. Must be between 1 and 256 characters in length.
 * @property description Description of the model. Must be between 1 and 128 characters in length.
 * @property name Name of the model. Must be alphanumeric. Must be between 1 and 128 characters in length.
 * @property schema Schema for the model. This should be a [JSON schema draft 4](https://tools.ietf.org/html/draft-zyp-json-schema-04) model. Must be less than or equal to 32768 characters in length.
 */
public data class ModelArgs(
    public val apiId: Output<String>? = null,
    public val contentType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val schema: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.ModelArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.ModelArgs =
        com.pulumi.aws.apigatewayv2.ModelArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .schema(schema?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ModelArgs].
 */
@PulumiTagMarker
public class ModelArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var contentType: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var schema: Output<String>? = null

    /**
     * @param value API identifier.
     */
    @JvmName("eoipdyccugokmsib")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value The content-type for the model, for example, `application/json`. Must be between 1 and 256 characters in length.
     */
    @JvmName("blupagrxihrfdken")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value Description of the model. Must be between 1 and 128 characters in length.
     */
    @JvmName("ddlsvgmbcbxtwmmn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the model. Must be alphanumeric. Must be between 1 and 128 characters in length.
     */
    @JvmName("xdtmsrqvntcuarog")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Schema for the model. This should be a [JSON schema draft 4](https://tools.ietf.org/html/draft-zyp-json-schema-04) model. Must be less than or equal to 32768 characters in length.
     */
    @JvmName("heaiputmtpsqyntf")
    public suspend fun schema(`value`: Output<String>) {
        this.schema = value
    }

    /**
     * @param value API identifier.
     */
    @JvmName("rhrlckepxlnjkvkp")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value The content-type for the model, for example, `application/json`. Must be between 1 and 256 characters in length.
     */
    @JvmName("cwfxjvyysbugqhaa")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value Description of the model. Must be between 1 and 128 characters in length.
     */
    @JvmName("gqikwesfgjlwswti")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the model. Must be alphanumeric. Must be between 1 and 128 characters in length.
     */
    @JvmName("aynkkrkojbxxyjop")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Schema for the model. This should be a [JSON schema draft 4](https://tools.ietf.org/html/draft-zyp-json-schema-04) model. Must be less than or equal to 32768 characters in length.
     */
    @JvmName("ctprsvxhrkbfepui")
    public suspend fun schema(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    internal fun build(): ModelArgs = ModelArgs(
        apiId = apiId,
        contentType = contentType,
        description = description,
        name = name,
        schema = schema,
    )
}
