@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.kotlin.outputs.RouteRequestParameter
import com.pulumi.aws.apigatewayv2.kotlin.outputs.RouteRequestParameter.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Route].
 */
@PulumiTagMarker
public class RouteResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouteArgs = RouteArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouteArgsBuilder.() -> Unit) {
        val builder = RouteArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Route {
        val builtJavaResource = com.pulumi.aws.apigatewayv2.Route(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Route(builtJavaResource)
    }
}

/**
 * Manages an Amazon API Gateway Version 2 route.
 * More information can be found in the [Amazon API Gateway Developer Guide](https://docs&#46;aws&#46;amazon&#46;com/apigateway/latest/developerguide/welcome&#46;html) for [WebSocket](https://docs&#46;aws&#46;amazon&#46;com/apigateway/latest/developerguide/websocket-api-develop-routes&#46;html) and [HTTP](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-routes.html) APIs.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apigatewayv2.Api("example", {
 *     name: "example-websocket-api",
 *     protocolType: "WEBSOCKET",
 *     routeSelectionExpression: "$request.body.action",
 * });
 * const exampleRoute = new aws.apigatewayv2.Route("example", {
 *     apiId: example.id,
 *     routeKey: "$default",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apigatewayv2.Api("example",
 *     name="example-websocket-api",
 *     protocol_type="WEBSOCKET",
 *     route_selection_expression="$request.body.action")
 * example_route = aws.apigatewayv2.Route("example",
 *     api_id=example.id,
 *     route_key="$default")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ApiGatewayV2.Api("example", new()
 *     {
 *         Name = "example-websocket-api",
 *         ProtocolType = "WEBSOCKET",
 *         RouteSelectionExpression = "$request.body.action",
 *     });
 *     var exampleRoute = new Aws.ApiGatewayV2.Route("example", new()
 *     {
 *         ApiId = example.Id,
 *         RouteKey = "$default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigatewayv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := apigatewayv2.NewApi(ctx, "example", &apigatewayv2.ApiArgs{
 * 			Name:                     pulumi.String("example-websocket-api"),
 * 			ProtocolType:             pulumi.String("WEBSOCKET"),
 * 			RouteSelectionExpression: pulumi.String("$request.body.action"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigatewayv2.NewRoute(ctx, "example", &apigatewayv2.RouteArgs{
 * 			ApiId:    example.ID(),
 * 			RouteKey: pulumi.String("$default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Api;
 * import com.pulumi.aws.apigatewayv2.ApiArgs;
 * import com.pulumi.aws.apigatewayv2.Route;
 * import com.pulumi.aws.apigatewayv2.RouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Api("example", ApiArgs.builder()
 *             .name("example-websocket-api")
 *             .protocolType("WEBSOCKET")
 *             .routeSelectionExpression("$request.body.action")
 *             .build());
 *         var exampleRoute = new Route("exampleRoute", RouteArgs.builder()
 *             .apiId(example.id())
 *             .routeKey("$default")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apigatewayv2:Api
 *     properties:
 *       name: example-websocket-api
 *       protocolType: WEBSOCKET
 *       routeSelectionExpression: $request.body.action
 *   exampleRoute:
 *     type: aws:apigatewayv2:Route
 *     name: example
 *     properties:
 *       apiId: ${example.id}
 *       routeKey: $default
 * ```
 * <!--End PulumiCodeChooser -->
 * ### HTTP Proxy Integration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apigatewayv2.Api("example", {
 *     name: "example-http-api",
 *     protocolType: "HTTP",
 * });
 * const exampleIntegration = new aws.apigatewayv2.Integration("example", {
 *     apiId: example.id,
 *     integrationType: "HTTP_PROXY",
 *     integrationMethod: "ANY",
 *     integrationUri: "https://example.com/{proxy}",
 * });
 * const exampleRoute = new aws.apigatewayv2.Route("example", {
 *     apiId: example.id,
 *     routeKey: "ANY /example/{proxy+}",
 *     target: pulumi.interpolate`integrations/${exampleIntegration.id}`,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apigatewayv2.Api("example",
 *     name="example-http-api",
 *     protocol_type="HTTP")
 * example_integration = aws.apigatewayv2.Integration("example",
 *     api_id=example.id,
 *     integration_type="HTTP_PROXY",
 *     integration_method="ANY",
 *     integration_uri="https://example.com/{proxy}")
 * example_route = aws.apigatewayv2.Route("example",
 *     api_id=example.id,
 *     route_key="ANY /example/{proxy+}",
 *     target=example_integration.id.apply(lambda id: f"integrations/{id}"))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ApiGatewayV2.Api("example", new()
 *     {
 *         Name = "example-http-api",
 *         ProtocolType = "HTTP",
 *     });
 *     var exampleIntegration = new Aws.ApiGatewayV2.Integration("example", new()
 *     {
 *         ApiId = example.Id,
 *         IntegrationType = "HTTP_PROXY",
 *         IntegrationMethod = "ANY",
 *         IntegrationUri = "https://example.com/{proxy}",
 *     });
 *     var exampleRoute = new Aws.ApiGatewayV2.Route("example", new()
 *     {
 *         ApiId = example.Id,
 *         RouteKey = "ANY /example/{proxy+}",
 *         Target = exampleIntegration.Id.Apply(id => $"integrations/{id}"),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigatewayv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := apigatewayv2.NewApi(ctx, "example", &apigatewayv2.ApiArgs{
 * 			Name:         pulumi.String("example-http-api"),
 * 			ProtocolType: pulumi.String("HTTP"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleIntegration, err := apigatewayv2.NewIntegration(ctx, "example", &apigatewayv2.IntegrationArgs{
 * 			ApiId:             example.ID(),
 * 			IntegrationType:   pulumi.String("HTTP_PROXY"),
 * 			IntegrationMethod: pulumi.String("ANY"),
 * 			IntegrationUri:    pulumi.String("https://example.com/{proxy}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigatewayv2.NewRoute(ctx, "example", &apigatewayv2.RouteArgs{
 * 			ApiId:    example.ID(),
 * 			RouteKey: pulumi.String("ANY /example/{proxy+}"),
 * 			Target: exampleIntegration.ID().ApplyT(func(id string) (string, error) {
 * 				return fmt.Sprintf("integrations/%v", id), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Api;
 * import com.pulumi.aws.apigatewayv2.ApiArgs;
 * import com.pulumi.aws.apigatewayv2.Integration;
 * import com.pulumi.aws.apigatewayv2.IntegrationArgs;
 * import com.pulumi.aws.apigatewayv2.Route;
 * import com.pulumi.aws.apigatewayv2.RouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Api("example", ApiArgs.builder()
 *             .name("example-http-api")
 *             .protocolType("HTTP")
 *             .build());
 *         var exampleIntegration = new Integration("exampleIntegration", IntegrationArgs.builder()
 *             .apiId(example.id())
 *             .integrationType("HTTP_PROXY")
 *             .integrationMethod("ANY")
 *             .integrationUri("https://example.com/{proxy}")
 *             .build());
 *         var exampleRoute = new Route("exampleRoute", RouteArgs.builder()
 *             .apiId(example.id())
 *             .routeKey("ANY /example/{proxy+}")
 *             .target(exampleIntegration.id().applyValue(id -> String.format("integrations/%s", id)))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apigatewayv2:Api
 *     properties:
 *       name: example-http-api
 *       protocolType: HTTP
 *   exampleIntegration:
 *     type: aws:apigatewayv2:Integration
 *     name: example
 *     properties:
 *       apiId: ${example.id}
 *       integrationType: HTTP_PROXY
 *       integrationMethod: ANY
 *       integrationUri: https://example.com/{proxy}
 *   exampleRoute:
 *     type: aws:apigatewayv2:Route
 *     name: example
 *     properties:
 *       apiId: ${example.id}
 *       routeKey: ANY /example/{proxy+}
 *       target: integrations/${exampleIntegration.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_route` using the API identifier and route identifier. For example:
 * ```sh
 * $ pulumi import aws:apigatewayv2/route:Route example aabbccddee/1122334
 * ```
 * -> __Note:__ The API Gateway managed route created as part of [_quick_create_](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-basic-concept.html#apigateway-definition-quick-create) cannot be imported.
 */
public class Route internal constructor(
    override val javaResource: com.pulumi.aws.apigatewayv2.Route,
) : KotlinCustomResource(javaResource, RouteMapper) {
    /**
     * API identifier.
     */
    public val apiId: Output<String>
        get() = javaResource.apiId().applyValue({ args0 -> args0 })

    /**
     * Boolean whether an API key is required for the route. Defaults to `false`. Supported only for WebSocket APIs.
     */
    public val apiKeyRequired: Output<Boolean>?
        get() = javaResource.apiKeyRequired().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Authorization scopes supported by this route. The scopes are used with a JWT authorizer to authorize the method invocation.
     */
    public val authorizationScopes: Output<List<String>>?
        get() = javaResource.authorizationScopes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Authorization type for the route.
     * For WebSocket APIs, valid values are `NONE` for open access, `AWS_IAM` for using AWS IAM permissions, and `CUSTOM` for using a Lambda authorizer.
     * For HTTP APIs, valid values are `NONE` for open access, `JWT` for using JSON Web Tokens, `AWS_IAM` for using AWS IAM permissions, and `CUSTOM` for using a Lambda authorizer.
     * Defaults to `NONE`.
     */
    public val authorizationType: Output<String>?
        get() = javaResource.authorizationType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identifier of the `aws.apigatewayv2.Authorizer` resource to be associated with this route.
     */
    public val authorizerId: Output<String>?
        get() = javaResource.authorizerId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The [model selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-model-selection-expressions) for the route. Supported only for WebSocket APIs.
     */
    public val modelSelectionExpression: Output<String>?
        get() = javaResource.modelSelectionExpression().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Operation name for the route. Must be between 1 and 64 characters in length.
     */
    public val operationName: Output<String>?
        get() = javaResource.operationName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Request models for the route. Supported only for WebSocket APIs.
     */
    public val requestModels: Output<Map<String, String>>?
        get() = javaResource.requestModels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Request parameters for the route. Supported only for WebSocket APIs.
     */
    public val requestParameters: Output<List<RouteRequestParameter>>?
        get() = javaResource.requestParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * Route key for the route. For HTTP APIs, the route key can be either `$default`, or a combination of an HTTP method and resource path, for example, `GET /pets`.
     */
    public val routeKey: Output<String>
        get() = javaResource.routeKey().applyValue({ args0 -> args0 })

    /**
     * The [route response selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-route-response-selection-expressions) for the route. Supported only for WebSocket APIs.
     */
    public val routeResponseSelectionExpression: Output<String>?
        get() = javaResource.routeResponseSelectionExpression().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Target for the route, of the form `integrations/`*`IntegrationID`*, where *`IntegrationID`* is the identifier of an `aws.apigatewayv2.Integration` resource.
     */
    public val target: Output<String>?
        get() = javaResource.target().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object RouteMapper : ResourceMapper<Route> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigatewayv2.Route::class == javaResource::class

    override fun map(javaResource: Resource): Route = Route(
        javaResource as
            com.pulumi.aws.apigatewayv2.Route,
    )
}

/**
 * @see [Route].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Route].
 */
public suspend fun route(name: String, block: suspend RouteResourceBuilder.() -> Unit): Route {
    val builder = RouteResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Route].
 * @param name The _unique_ name of the resulting resource.
 */
public fun route(name: String): Route {
    val builder = RouteResourceBuilder()
    builder.name(name)
    return builder.build()
}
