@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.RouteArgs.builder
import com.pulumi.aws.apigatewayv2.kotlin.inputs.RouteRequestParameterArgs
import com.pulumi.aws.apigatewayv2.kotlin.inputs.RouteRequestParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Amazon API Gateway Version 2 route.
 * More information can be found in the [Amazon API Gateway Developer Guide](https://docs&#46;aws&#46;amazon&#46;com/apigateway/latest/developerguide/welcome&#46;html) for [WebSocket](https://docs&#46;aws&#46;amazon&#46;com/apigateway/latest/developerguide/websocket-api-develop-routes&#46;html) and [HTTP](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-routes.html) APIs.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apigatewayv2.Api("example", {
 *     name: "example-websocket-api",
 *     protocolType: "WEBSOCKET",
 *     routeSelectionExpression: "$request.body.action",
 * });
 * const exampleRoute = new aws.apigatewayv2.Route("example", {
 *     apiId: example.id,
 *     routeKey: "$default",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apigatewayv2.Api("example",
 *     name="example-websocket-api",
 *     protocol_type="WEBSOCKET",
 *     route_selection_expression="$request.body.action")
 * example_route = aws.apigatewayv2.Route("example",
 *     api_id=example.id,
 *     route_key="$default")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ApiGatewayV2.Api("example", new()
 *     {
 *         Name = "example-websocket-api",
 *         ProtocolType = "WEBSOCKET",
 *         RouteSelectionExpression = "$request.body.action",
 *     });
 *     var exampleRoute = new Aws.ApiGatewayV2.Route("example", new()
 *     {
 *         ApiId = example.Id,
 *         RouteKey = "$default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigatewayv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := apigatewayv2.NewApi(ctx, "example", &apigatewayv2.ApiArgs{
 * 			Name:                     pulumi.String("example-websocket-api"),
 * 			ProtocolType:             pulumi.String("WEBSOCKET"),
 * 			RouteSelectionExpression: pulumi.String("$request.body.action"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigatewayv2.NewRoute(ctx, "example", &apigatewayv2.RouteArgs{
 * 			ApiId:    example.ID(),
 * 			RouteKey: pulumi.String("$default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Api;
 * import com.pulumi.aws.apigatewayv2.ApiArgs;
 * import com.pulumi.aws.apigatewayv2.Route;
 * import com.pulumi.aws.apigatewayv2.RouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Api("example", ApiArgs.builder()
 *             .name("example-websocket-api")
 *             .protocolType("WEBSOCKET")
 *             .routeSelectionExpression("$request.body.action")
 *             .build());
 *         var exampleRoute = new Route("exampleRoute", RouteArgs.builder()
 *             .apiId(example.id())
 *             .routeKey("$default")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apigatewayv2:Api
 *     properties:
 *       name: example-websocket-api
 *       protocolType: WEBSOCKET
 *       routeSelectionExpression: $request.body.action
 *   exampleRoute:
 *     type: aws:apigatewayv2:Route
 *     name: example
 *     properties:
 *       apiId: ${example.id}
 *       routeKey: $default
 * ```
 * <!--End PulumiCodeChooser -->
 * ### HTTP Proxy Integration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apigatewayv2.Api("example", {
 *     name: "example-http-api",
 *     protocolType: "HTTP",
 * });
 * const exampleIntegration = new aws.apigatewayv2.Integration("example", {
 *     apiId: example.id,
 *     integrationType: "HTTP_PROXY",
 *     integrationMethod: "ANY",
 *     integrationUri: "https://example.com/{proxy}",
 * });
 * const exampleRoute = new aws.apigatewayv2.Route("example", {
 *     apiId: example.id,
 *     routeKey: "ANY /example/{proxy+}",
 *     target: pulumi.interpolate`integrations/${exampleIntegration.id}`,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apigatewayv2.Api("example",
 *     name="example-http-api",
 *     protocol_type="HTTP")
 * example_integration = aws.apigatewayv2.Integration("example",
 *     api_id=example.id,
 *     integration_type="HTTP_PROXY",
 *     integration_method="ANY",
 *     integration_uri="https://example.com/{proxy}")
 * example_route = aws.apigatewayv2.Route("example",
 *     api_id=example.id,
 *     route_key="ANY /example/{proxy+}",
 *     target=example_integration.id.apply(lambda id: f"integrations/{id}"))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ApiGatewayV2.Api("example", new()
 *     {
 *         Name = "example-http-api",
 *         ProtocolType = "HTTP",
 *     });
 *     var exampleIntegration = new Aws.ApiGatewayV2.Integration("example", new()
 *     {
 *         ApiId = example.Id,
 *         IntegrationType = "HTTP_PROXY",
 *         IntegrationMethod = "ANY",
 *         IntegrationUri = "https://example.com/{proxy}",
 *     });
 *     var exampleRoute = new Aws.ApiGatewayV2.Route("example", new()
 *     {
 *         ApiId = example.Id,
 *         RouteKey = "ANY /example/{proxy+}",
 *         Target = exampleIntegration.Id.Apply(id => $"integrations/{id}"),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigatewayv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := apigatewayv2.NewApi(ctx, "example", &apigatewayv2.ApiArgs{
 * 			Name:         pulumi.String("example-http-api"),
 * 			ProtocolType: pulumi.String("HTTP"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleIntegration, err := apigatewayv2.NewIntegration(ctx, "example", &apigatewayv2.IntegrationArgs{
 * 			ApiId:             example.ID(),
 * 			IntegrationType:   pulumi.String("HTTP_PROXY"),
 * 			IntegrationMethod: pulumi.String("ANY"),
 * 			IntegrationUri:    pulumi.String("https://example.com/{proxy}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigatewayv2.NewRoute(ctx, "example", &apigatewayv2.RouteArgs{
 * 			ApiId:    example.ID(),
 * 			RouteKey: pulumi.String("ANY /example/{proxy+}"),
 * 			Target: exampleIntegration.ID().ApplyT(func(id string) (string, error) {
 * 				return fmt.Sprintf("integrations/%v", id), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Api;
 * import com.pulumi.aws.apigatewayv2.ApiArgs;
 * import com.pulumi.aws.apigatewayv2.Integration;
 * import com.pulumi.aws.apigatewayv2.IntegrationArgs;
 * import com.pulumi.aws.apigatewayv2.Route;
 * import com.pulumi.aws.apigatewayv2.RouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Api("example", ApiArgs.builder()
 *             .name("example-http-api")
 *             .protocolType("HTTP")
 *             .build());
 *         var exampleIntegration = new Integration("exampleIntegration", IntegrationArgs.builder()
 *             .apiId(example.id())
 *             .integrationType("HTTP_PROXY")
 *             .integrationMethod("ANY")
 *             .integrationUri("https://example.com/{proxy}")
 *             .build());
 *         var exampleRoute = new Route("exampleRoute", RouteArgs.builder()
 *             .apiId(example.id())
 *             .routeKey("ANY /example/{proxy+}")
 *             .target(exampleIntegration.id().applyValue(id -> String.format("integrations/%s", id)))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apigatewayv2:Api
 *     properties:
 *       name: example-http-api
 *       protocolType: HTTP
 *   exampleIntegration:
 *     type: aws:apigatewayv2:Integration
 *     name: example
 *     properties:
 *       apiId: ${example.id}
 *       integrationType: HTTP_PROXY
 *       integrationMethod: ANY
 *       integrationUri: https://example.com/{proxy}
 *   exampleRoute:
 *     type: aws:apigatewayv2:Route
 *     name: example
 *     properties:
 *       apiId: ${example.id}
 *       routeKey: ANY /example/{proxy+}
 *       target: integrations/${exampleIntegration.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_route` using the API identifier and route identifier. For example:
 * ```sh
 * $ pulumi import aws:apigatewayv2/route:Route example aabbccddee/1122334
 * ```
 * -> __Note:__ The API Gateway managed route created as part of [_quick_create_](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-basic-concept.html#apigateway-definition-quick-create) cannot be imported.
 * @property apiId API identifier.
 * @property apiKeyRequired Boolean whether an API key is required for the route. Defaults to `false`. Supported only for WebSocket APIs.
 * @property authorizationScopes Authorization scopes supported by this route. The scopes are used with a JWT authorizer to authorize the method invocation.
 * @property authorizationType Authorization type for the route.
 * For WebSocket APIs, valid values are `NONE` for open access, `AWS_IAM` for using AWS IAM permissions, and `CUSTOM` for using a Lambda authorizer.
 * For HTTP APIs, valid values are `NONE` for open access, `JWT` for using JSON Web Tokens, `AWS_IAM` for using AWS IAM permissions, and `CUSTOM` for using a Lambda authorizer.
 * Defaults to `NONE`.
 * @property authorizerId Identifier of the `aws.apigatewayv2.Authorizer` resource to be associated with this route.
 * @property modelSelectionExpression The [model selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-model-selection-expressions) for the route. Supported only for WebSocket APIs.
 * @property operationName Operation name for the route. Must be between 1 and 64 characters in length.
 * @property requestModels Request models for the route. Supported only for WebSocket APIs.
 * @property requestParameters Request parameters for the route. Supported only for WebSocket APIs.
 * @property routeKey Route key for the route. For HTTP APIs, the route key can be either `$default`, or a combination of an HTTP method and resource path, for example, `GET /pets`.
 * @property routeResponseSelectionExpression The [route response selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-route-response-selection-expressions) for the route. Supported only for WebSocket APIs.
 * @property target Target for the route, of the form `integrations/`*`IntegrationID`*, where *`IntegrationID`* is the identifier of an `aws.apigatewayv2.Integration` resource.
 */
public data class RouteArgs(
    public val apiId: Output<String>? = null,
    public val apiKeyRequired: Output<Boolean>? = null,
    public val authorizationScopes: Output<List<String>>? = null,
    public val authorizationType: Output<String>? = null,
    public val authorizerId: Output<String>? = null,
    public val modelSelectionExpression: Output<String>? = null,
    public val operationName: Output<String>? = null,
    public val requestModels: Output<Map<String, String>>? = null,
    public val requestParameters: Output<List<RouteRequestParameterArgs>>? = null,
    public val routeKey: Output<String>? = null,
    public val routeResponseSelectionExpression: Output<String>? = null,
    public val target: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.RouteArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.RouteArgs =
        com.pulumi.aws.apigatewayv2.RouteArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .apiKeyRequired(apiKeyRequired?.applyValue({ args0 -> args0 }))
            .authorizationScopes(authorizationScopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authorizationType(authorizationType?.applyValue({ args0 -> args0 }))
            .authorizerId(authorizerId?.applyValue({ args0 -> args0 }))
            .modelSelectionExpression(modelSelectionExpression?.applyValue({ args0 -> args0 }))
            .operationName(operationName?.applyValue({ args0 -> args0 }))
            .requestModels(
                requestModels?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .requestParameters(
                requestParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .routeKey(routeKey?.applyValue({ args0 -> args0 }))
            .routeResponseSelectionExpression(routeResponseSelectionExpression?.applyValue({ args0 -> args0 }))
            .target(target?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteArgs].
 */
@PulumiTagMarker
public class RouteArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var apiKeyRequired: Output<Boolean>? = null

    private var authorizationScopes: Output<List<String>>? = null

    private var authorizationType: Output<String>? = null

    private var authorizerId: Output<String>? = null

    private var modelSelectionExpression: Output<String>? = null

    private var operationName: Output<String>? = null

    private var requestModels: Output<Map<String, String>>? = null

    private var requestParameters: Output<List<RouteRequestParameterArgs>>? = null

    private var routeKey: Output<String>? = null

    private var routeResponseSelectionExpression: Output<String>? = null

    private var target: Output<String>? = null

    /**
     * @param value API identifier.
     */
    @JvmName("epnpcilupuqufmqj")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Boolean whether an API key is required for the route. Defaults to `false`. Supported only for WebSocket APIs.
     */
    @JvmName("jdqgoitlnkblsdgq")
    public suspend fun apiKeyRequired(`value`: Output<Boolean>) {
        this.apiKeyRequired = value
    }

    /**
     * @param value Authorization scopes supported by this route. The scopes are used with a JWT authorizer to authorize the method invocation.
     */
    @JvmName("hoixhmjcggswrusw")
    public suspend fun authorizationScopes(`value`: Output<List<String>>) {
        this.authorizationScopes = value
    }

    @JvmName("xqfpuuaouihcsyyk")
    public suspend fun authorizationScopes(vararg values: Output<String>) {
        this.authorizationScopes = Output.all(values.asList())
    }

    /**
     * @param values Authorization scopes supported by this route. The scopes are used with a JWT authorizer to authorize the method invocation.
     */
    @JvmName("cknwkvcxrcxcemfi")
    public suspend fun authorizationScopes(values: List<Output<String>>) {
        this.authorizationScopes = Output.all(values)
    }

    /**
     * @param value Authorization type for the route.
     * For WebSocket APIs, valid values are `NONE` for open access, `AWS_IAM` for using AWS IAM permissions, and `CUSTOM` for using a Lambda authorizer.
     * For HTTP APIs, valid values are `NONE` for open access, `JWT` for using JSON Web Tokens, `AWS_IAM` for using AWS IAM permissions, and `CUSTOM` for using a Lambda authorizer.
     * Defaults to `NONE`.
     */
    @JvmName("qgwjvylhvxmtpxcr")
    public suspend fun authorizationType(`value`: Output<String>) {
        this.authorizationType = value
    }

    /**
     * @param value Identifier of the `aws.apigatewayv2.Authorizer` resource to be associated with this route.
     */
    @JvmName("tpwswkxbntnjppxu")
    public suspend fun authorizerId(`value`: Output<String>) {
        this.authorizerId = value
    }

    /**
     * @param value The [model selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-model-selection-expressions) for the route. Supported only for WebSocket APIs.
     */
    @JvmName("kxirydhpfcnvtfvd")
    public suspend fun modelSelectionExpression(`value`: Output<String>) {
        this.modelSelectionExpression = value
    }

    /**
     * @param value Operation name for the route. Must be between 1 and 64 characters in length.
     */
    @JvmName("ucmdtrggiagkxgcg")
    public suspend fun operationName(`value`: Output<String>) {
        this.operationName = value
    }

    /**
     * @param value Request models for the route. Supported only for WebSocket APIs.
     */
    @JvmName("vxpntyrttkdgwqiy")
    public suspend fun requestModels(`value`: Output<Map<String, String>>) {
        this.requestModels = value
    }

    /**
     * @param value Request parameters for the route. Supported only for WebSocket APIs.
     */
    @JvmName("aakskvgmudaxpnlb")
    public suspend fun requestParameters(`value`: Output<List<RouteRequestParameterArgs>>) {
        this.requestParameters = value
    }

    @JvmName("anpbsweutwsgurul")
    public suspend fun requestParameters(vararg values: Output<RouteRequestParameterArgs>) {
        this.requestParameters = Output.all(values.asList())
    }

    /**
     * @param values Request parameters for the route. Supported only for WebSocket APIs.
     */
    @JvmName("msrorfopexhhthpo")
    public suspend fun requestParameters(values: List<Output<RouteRequestParameterArgs>>) {
        this.requestParameters = Output.all(values)
    }

    /**
     * @param value Route key for the route. For HTTP APIs, the route key can be either `$default`, or a combination of an HTTP method and resource path, for example, `GET /pets`.
     */
    @JvmName("xujrkbckhsisvkoo")
    public suspend fun routeKey(`value`: Output<String>) {
        this.routeKey = value
    }

    /**
     * @param value The [route response selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-route-response-selection-expressions) for the route. Supported only for WebSocket APIs.
     */
    @JvmName("erykfuuirmqctjue")
    public suspend fun routeResponseSelectionExpression(`value`: Output<String>) {
        this.routeResponseSelectionExpression = value
    }

    /**
     * @param value Target for the route, of the form `integrations/`*`IntegrationID`*, where *`IntegrationID`* is the identifier of an `aws.apigatewayv2.Integration` resource.
     */
    @JvmName("vyqilpttvxljqlyl")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value API identifier.
     */
    @JvmName("xqtlylvuuitxiuqa")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Boolean whether an API key is required for the route. Defaults to `false`. Supported only for WebSocket APIs.
     */
    @JvmName("wtqqdatkaxcuucfd")
    public suspend fun apiKeyRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiKeyRequired = mapped
    }

    /**
     * @param value Authorization scopes supported by this route. The scopes are used with a JWT authorizer to authorize the method invocation.
     */
    @JvmName("yfgrjekkqdqjhhha")
    public suspend fun authorizationScopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationScopes = mapped
    }

    /**
     * @param values Authorization scopes supported by this route. The scopes are used with a JWT authorizer to authorize the method invocation.
     */
    @JvmName("vfoyyenmxueddjpp")
    public suspend fun authorizationScopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizationScopes = mapped
    }

    /**
     * @param value Authorization type for the route.
     * For WebSocket APIs, valid values are `NONE` for open access, `AWS_IAM` for using AWS IAM permissions, and `CUSTOM` for using a Lambda authorizer.
     * For HTTP APIs, valid values are `NONE` for open access, `JWT` for using JSON Web Tokens, `AWS_IAM` for using AWS IAM permissions, and `CUSTOM` for using a Lambda authorizer.
     * Defaults to `NONE`.
     */
    @JvmName("fcltoepyphfgighb")
    public suspend fun authorizationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationType = mapped
    }

    /**
     * @param value Identifier of the `aws.apigatewayv2.Authorizer` resource to be associated with this route.
     */
    @JvmName("grgnthfnlxiomrel")
    public suspend fun authorizerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizerId = mapped
    }

    /**
     * @param value The [model selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-model-selection-expressions) for the route. Supported only for WebSocket APIs.
     */
    @JvmName("upitwnycinqmvrgj")
    public suspend fun modelSelectionExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelSelectionExpression = mapped
    }

    /**
     * @param value Operation name for the route. Must be between 1 and 64 characters in length.
     */
    @JvmName("lggbpxkniveqpyeg")
    public suspend fun operationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationName = mapped
    }

    /**
     * @param value Request models for the route. Supported only for WebSocket APIs.
     */
    @JvmName("hjysanxmcwqwmvph")
    public suspend fun requestModels(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestModels = mapped
    }

    /**
     * @param values Request models for the route. Supported only for WebSocket APIs.
     */
    @JvmName("mnhmihkjajcmyibu")
    public fun requestModels(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestModels = mapped
    }

    /**
     * @param value Request parameters for the route. Supported only for WebSocket APIs.
     */
    @JvmName("kmpawnnbofggtcyd")
    public suspend fun requestParameters(`value`: List<RouteRequestParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestParameters = mapped
    }

    /**
     * @param argument Request parameters for the route. Supported only for WebSocket APIs.
     */
    @JvmName("giicirbhxlpesyjt")
    public suspend fun requestParameters(argument: List<suspend RouteRequestParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RouteRequestParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.requestParameters = mapped
    }

    /**
     * @param argument Request parameters for the route. Supported only for WebSocket APIs.
     */
    @JvmName("dpfxspwasbthhmdo")
    public suspend fun requestParameters(vararg argument: suspend RouteRequestParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RouteRequestParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.requestParameters = mapped
    }

    /**
     * @param argument Request parameters for the route. Supported only for WebSocket APIs.
     */
    @JvmName("brpmoadqsbshwwby")
    public suspend fun requestParameters(argument: suspend RouteRequestParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RouteRequestParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.requestParameters = mapped
    }

    /**
     * @param values Request parameters for the route. Supported only for WebSocket APIs.
     */
    @JvmName("glnfmxrximsjkwqk")
    public suspend fun requestParameters(vararg values: RouteRequestParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestParameters = mapped
    }

    /**
     * @param value Route key for the route. For HTTP APIs, the route key can be either `$default`, or a combination of an HTTP method and resource path, for example, `GET /pets`.
     */
    @JvmName("cymwoxmotwnbamrh")
    public suspend fun routeKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeKey = mapped
    }

    /**
     * @param value The [route response selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-route-response-selection-expressions) for the route. Supported only for WebSocket APIs.
     */
    @JvmName("geajfbmpongordqo")
    public suspend fun routeResponseSelectionExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeResponseSelectionExpression = mapped
    }

    /**
     * @param value Target for the route, of the form `integrations/`*`IntegrationID`*, where *`IntegrationID`* is the identifier of an `aws.apigatewayv2.Integration` resource.
     */
    @JvmName("vfyvmubnofdygtcv")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    internal fun build(): RouteArgs = RouteArgs(
        apiId = apiId,
        apiKeyRequired = apiKeyRequired,
        authorizationScopes = authorizationScopes,
        authorizationType = authorizationType,
        authorizerId = authorizerId,
        modelSelectionExpression = modelSelectionExpression,
        operationName = operationName,
        requestModels = requestModels,
        requestParameters = requestParameters,
        routeKey = routeKey,
        routeResponseSelectionExpression = routeResponseSelectionExpression,
        target = target,
    )
}
