@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.RouteResponseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Amazon API Gateway Version 2 route response.
 * More information can be found in the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api.html).
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apigatewayv2.RouteResponse("example", {
 *     apiId: exampleAwsApigatewayv2Api.id,
 *     routeId: exampleAwsApigatewayv2Route.id,
 *     routeResponseKey: "$default",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apigatewayv2.RouteResponse("example",
 *     api_id=example_aws_apigatewayv2_api["id"],
 *     route_id=example_aws_apigatewayv2_route["id"],
 *     route_response_key="$default")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ApiGatewayV2.RouteResponse("example", new()
 *     {
 *         ApiId = exampleAwsApigatewayv2Api.Id,
 *         RouteId = exampleAwsApigatewayv2Route.Id,
 *         RouteResponseKey = "$default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigatewayv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigatewayv2.NewRouteResponse(ctx, "example", &apigatewayv2.RouteResponseArgs{
 * 			ApiId:            pulumi.Any(exampleAwsApigatewayv2Api.Id),
 * 			RouteId:          pulumi.Any(exampleAwsApigatewayv2Route.Id),
 * 			RouteResponseKey: pulumi.String("$default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.RouteResponse;
 * import com.pulumi.aws.apigatewayv2.RouteResponseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RouteResponse("example", RouteResponseArgs.builder()
 *             .apiId(exampleAwsApigatewayv2Api.id())
 *             .routeId(exampleAwsApigatewayv2Route.id())
 *             .routeResponseKey("$default")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apigatewayv2:RouteResponse
 *     properties:
 *       apiId: ${exampleAwsApigatewayv2Api.id}
 *       routeId: ${exampleAwsApigatewayv2Route.id}
 *       routeResponseKey: $default
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Enabling Two-Way Communication
 * For websocket routes that require two-way communication enabled, an `aws.apigatewayv2.RouteResponse` needs to be added to the route with `route_response_key = "$default"`. More information available  is available in [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api.html).
 * You can only define the $default route response for WebSocket APIs. You can use an integration response to manipulate the response from a backend service. For more information, see [Overview of integration responses](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-integration-responses.html#apigateway-websocket-api-integration-response-overview).
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_route_response` using the API identifier, route identifier and route response identifier. For example:
 * ```sh
 * $ pulumi import aws:apigatewayv2/routeResponse:RouteResponse example aabbccddee/1122334/998877
 * ```
 * @property apiId API identifier.
 * @property modelSelectionExpression The [model selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-model-selection-expressions) for the route response.
 * @property responseModels Response models for the route response.
 * @property routeId Identifier of the `aws.apigatewayv2.Route`.
 * @property routeResponseKey Route response key.
 */
public data class RouteResponseArgs(
    public val apiId: Output<String>? = null,
    public val modelSelectionExpression: Output<String>? = null,
    public val responseModels: Output<Map<String, String>>? = null,
    public val routeId: Output<String>? = null,
    public val routeResponseKey: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.RouteResponseArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.RouteResponseArgs =
        com.pulumi.aws.apigatewayv2.RouteResponseArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .modelSelectionExpression(modelSelectionExpression?.applyValue({ args0 -> args0 }))
            .responseModels(
                responseModels?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .routeId(routeId?.applyValue({ args0 -> args0 }))
            .routeResponseKey(routeResponseKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteResponseArgs].
 */
@PulumiTagMarker
public class RouteResponseArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var modelSelectionExpression: Output<String>? = null

    private var responseModels: Output<Map<String, String>>? = null

    private var routeId: Output<String>? = null

    private var routeResponseKey: Output<String>? = null

    /**
     * @param value API identifier.
     */
    @JvmName("jbatwvlqnkeafdtl")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value The [model selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-model-selection-expressions) for the route response.
     */
    @JvmName("jwmqyahvvfmvbpcv")
    public suspend fun modelSelectionExpression(`value`: Output<String>) {
        this.modelSelectionExpression = value
    }

    /**
     * @param value Response models for the route response.
     */
    @JvmName("pgrurhyogjqslffq")
    public suspend fun responseModels(`value`: Output<Map<String, String>>) {
        this.responseModels = value
    }

    /**
     * @param value Identifier of the `aws.apigatewayv2.Route`.
     */
    @JvmName("hxqxyescwgwjnvvt")
    public suspend fun routeId(`value`: Output<String>) {
        this.routeId = value
    }

    /**
     * @param value Route response key.
     */
    @JvmName("uivmnokdwdoiucfg")
    public suspend fun routeResponseKey(`value`: Output<String>) {
        this.routeResponseKey = value
    }

    /**
     * @param value API identifier.
     */
    @JvmName("kxescrvreofybtup")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value The [model selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-model-selection-expressions) for the route response.
     */
    @JvmName("pmsodedylafxihxn")
    public suspend fun modelSelectionExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelSelectionExpression = mapped
    }

    /**
     * @param value Response models for the route response.
     */
    @JvmName("mrmxhexpdigsejoi")
    public suspend fun responseModels(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseModels = mapped
    }

    /**
     * @param values Response models for the route response.
     */
    @JvmName("cmunswvrgdqenmlb")
    public fun responseModels(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responseModels = mapped
    }

    /**
     * @param value Identifier of the `aws.apigatewayv2.Route`.
     */
    @JvmName("ajgbrixuvudfocto")
    public suspend fun routeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeId = mapped
    }

    /**
     * @param value Route response key.
     */
    @JvmName("rllwrqkexdjkumec")
    public suspend fun routeResponseKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeResponseKey = mapped
    }

    internal fun build(): RouteResponseArgs = RouteResponseArgs(
        apiId = apiId,
        modelSelectionExpression = modelSelectionExpression,
        responseModels = responseModels,
        routeId = routeId,
        routeResponseKey = routeResponseKey,
    )
}
