@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.StageArgs.builder
import com.pulumi.aws.apigatewayv2.kotlin.inputs.StageAccessLogSettingsArgs
import com.pulumi.aws.apigatewayv2.kotlin.inputs.StageAccessLogSettingsArgsBuilder
import com.pulumi.aws.apigatewayv2.kotlin.inputs.StageDefaultRouteSettingsArgs
import com.pulumi.aws.apigatewayv2.kotlin.inputs.StageDefaultRouteSettingsArgsBuilder
import com.pulumi.aws.apigatewayv2.kotlin.inputs.StageRouteSettingArgs
import com.pulumi.aws.apigatewayv2.kotlin.inputs.StageRouteSettingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Amazon API Gateway Version 2 stage.
 * More information can be found in the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api.html).
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apigatewayv2.Stage("example", {
 *     apiId: exampleAwsApigatewayv2Api.id,
 *     name: "example-stage",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apigatewayv2.Stage("example",
 *     api_id=example_aws_apigatewayv2_api["id"],
 *     name="example-stage")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ApiGatewayV2.Stage("example", new()
 *     {
 *         ApiId = exampleAwsApigatewayv2Api.Id,
 *         Name = "example-stage",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigatewayv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigatewayv2.NewStage(ctx, "example", &apigatewayv2.StageArgs{
 * 			ApiId: pulumi.Any(exampleAwsApigatewayv2Api.Id),
 * 			Name:  pulumi.String("example-stage"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Stage;
 * import com.pulumi.aws.apigatewayv2.StageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Stage("example", StageArgs.builder()
 *             .apiId(exampleAwsApigatewayv2Api.id())
 *             .name("example-stage")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apigatewayv2:Stage
 *     properties:
 *       apiId: ${exampleAwsApigatewayv2Api.id}
 *       name: example-stage
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_stage` using the API identifier and stage name. For example:
 * ```sh
 * $ pulumi import aws:apigatewayv2/stage:Stage example aabbccddee/example-stage
 * ```
 * -> __Note:__ The API Gateway managed stage created as part of [_quick_create_](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-basic-concept.html#apigateway-definition-quick-create) cannot be imported.
 * @property accessLogSettings Settings for logging access in this stage.
 * Use the `aws.apigateway.Account` resource to configure [permissions for CloudWatch Logging](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html#set-up-access-logging-permissions).
 * @property apiId API identifier.
 * @property autoDeploy Whether updates to an API automatically trigger a new deployment. Defaults to `false`. Applicable for HTTP APIs.
 * @property clientCertificateId Identifier of a client certificate for the stage. Use the `aws.apigateway.ClientCertificate` resource to configure a client certificate.
 * Supported only for WebSocket APIs.
 * @property defaultRouteSettings Default route settings for the stage.
 * @property deploymentId Deployment identifier of the stage. Use the `aws.apigatewayv2.Deployment` resource to configure a deployment.
 * @property description Description for the stage. Must be less than or equal to 1024 characters in length.
 * @property name Name of the stage. Must be between 1 and 128 characters in length.
 * The following arguments are optional:
 * @property routeSettings Route settings for the stage.
 * @property stageVariables Map that defines the stage variables for the stage.
 * @property tags Map of tags to assign to the stage. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class StageArgs(
    public val accessLogSettings: Output<StageAccessLogSettingsArgs>? = null,
    public val apiId: Output<String>? = null,
    public val autoDeploy: Output<Boolean>? = null,
    public val clientCertificateId: Output<String>? = null,
    public val defaultRouteSettings: Output<StageDefaultRouteSettingsArgs>? = null,
    public val deploymentId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val routeSettings: Output<List<StageRouteSettingArgs>>? = null,
    public val stageVariables: Output<Map<String, String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.StageArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.StageArgs =
        com.pulumi.aws.apigatewayv2.StageArgs.builder()
            .accessLogSettings(accessLogSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .autoDeploy(autoDeploy?.applyValue({ args0 -> args0 }))
            .clientCertificateId(clientCertificateId?.applyValue({ args0 -> args0 }))
            .defaultRouteSettings(
                defaultRouteSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .deploymentId(deploymentId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .routeSettings(
                routeSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .stageVariables(
                stageVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [StageArgs].
 */
@PulumiTagMarker
public class StageArgsBuilder internal constructor() {
    private var accessLogSettings: Output<StageAccessLogSettingsArgs>? = null

    private var apiId: Output<String>? = null

    private var autoDeploy: Output<Boolean>? = null

    private var clientCertificateId: Output<String>? = null

    private var defaultRouteSettings: Output<StageDefaultRouteSettingsArgs>? = null

    private var deploymentId: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var routeSettings: Output<List<StageRouteSettingArgs>>? = null

    private var stageVariables: Output<Map<String, String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Settings for logging access in this stage.
     * Use the `aws.apigateway.Account` resource to configure [permissions for CloudWatch Logging](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html#set-up-access-logging-permissions).
     */
    @JvmName("kkmvwofsvqergpqr")
    public suspend fun accessLogSettings(`value`: Output<StageAccessLogSettingsArgs>) {
        this.accessLogSettings = value
    }

    /**
     * @param value API identifier.
     */
    @JvmName("nwqosolivhpietof")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Whether updates to an API automatically trigger a new deployment. Defaults to `false`. Applicable for HTTP APIs.
     */
    @JvmName("aehekfbpwqqwufsj")
    public suspend fun autoDeploy(`value`: Output<Boolean>) {
        this.autoDeploy = value
    }

    /**
     * @param value Identifier of a client certificate for the stage. Use the `aws.apigateway.ClientCertificate` resource to configure a client certificate.
     * Supported only for WebSocket APIs.
     */
    @JvmName("llejhrkllcbrbaat")
    public suspend fun clientCertificateId(`value`: Output<String>) {
        this.clientCertificateId = value
    }

    /**
     * @param value Default route settings for the stage.
     */
    @JvmName("xhsanpcsnthxpakw")
    public suspend fun defaultRouteSettings(`value`: Output<StageDefaultRouteSettingsArgs>) {
        this.defaultRouteSettings = value
    }

    /**
     * @param value Deployment identifier of the stage. Use the `aws.apigatewayv2.Deployment` resource to configure a deployment.
     */
    @JvmName("iwbtyrioddludclt")
    public suspend fun deploymentId(`value`: Output<String>) {
        this.deploymentId = value
    }

    /**
     * @param value Description for the stage. Must be less than or equal to 1024 characters in length.
     */
    @JvmName("ftydfvbxgypcnqdw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the stage. Must be between 1 and 128 characters in length.
     * The following arguments are optional:
     */
    @JvmName("imaqjrugrqnuiufw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Route settings for the stage.
     */
    @JvmName("gtadwnwmxklljcqn")
    public suspend fun routeSettings(`value`: Output<List<StageRouteSettingArgs>>) {
        this.routeSettings = value
    }

    @JvmName("fdngbplxeqdskjcq")
    public suspend fun routeSettings(vararg values: Output<StageRouteSettingArgs>) {
        this.routeSettings = Output.all(values.asList())
    }

    /**
     * @param values Route settings for the stage.
     */
    @JvmName("tkyiulwvlfuxffsd")
    public suspend fun routeSettings(values: List<Output<StageRouteSettingArgs>>) {
        this.routeSettings = Output.all(values)
    }

    /**
     * @param value Map that defines the stage variables for the stage.
     */
    @JvmName("ooaqakoqwpjslaxf")
    public suspend fun stageVariables(`value`: Output<Map<String, String>>) {
        this.stageVariables = value
    }

    /**
     * @param value Map of tags to assign to the stage. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iqsojvwsaabhtjuk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Settings for logging access in this stage.
     * Use the `aws.apigateway.Account` resource to configure [permissions for CloudWatch Logging](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html#set-up-access-logging-permissions).
     */
    @JvmName("kjkrodqllibpepmc")
    public suspend fun accessLogSettings(`value`: StageAccessLogSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLogSettings = mapped
    }

    /**
     * @param argument Settings for logging access in this stage.
     * Use the `aws.apigateway.Account` resource to configure [permissions for CloudWatch Logging](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html#set-up-access-logging-permissions).
     */
    @JvmName("fwosgwnvaytofdxg")
    public suspend fun accessLogSettings(argument: suspend StageAccessLogSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = StageAccessLogSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessLogSettings = mapped
    }

    /**
     * @param value API identifier.
     */
    @JvmName("jlgsxkllikquultn")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Whether updates to an API automatically trigger a new deployment. Defaults to `false`. Applicable for HTTP APIs.
     */
    @JvmName("lpwmqkunmscteudh")
    public suspend fun autoDeploy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoDeploy = mapped
    }

    /**
     * @param value Identifier of a client certificate for the stage. Use the `aws.apigateway.ClientCertificate` resource to configure a client certificate.
     * Supported only for WebSocket APIs.
     */
    @JvmName("tkxjbxwevmvjnqew")
    public suspend fun clientCertificateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCertificateId = mapped
    }

    /**
     * @param value Default route settings for the stage.
     */
    @JvmName("enfbtoolrqqsergw")
    public suspend fun defaultRouteSettings(`value`: StageDefaultRouteSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultRouteSettings = mapped
    }

    /**
     * @param argument Default route settings for the stage.
     */
    @JvmName("fmhlglvibmqihiai")
    public suspend fun defaultRouteSettings(argument: suspend StageDefaultRouteSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = StageDefaultRouteSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultRouteSettings = mapped
    }

    /**
     * @param value Deployment identifier of the stage. Use the `aws.apigatewayv2.Deployment` resource to configure a deployment.
     */
    @JvmName("adhxypfyclqnlslx")
    public suspend fun deploymentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentId = mapped
    }

    /**
     * @param value Description for the stage. Must be less than or equal to 1024 characters in length.
     */
    @JvmName("vhrxxmrnbcainbit")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the stage. Must be between 1 and 128 characters in length.
     * The following arguments are optional:
     */
    @JvmName("ekwxonflkemovqny")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Route settings for the stage.
     */
    @JvmName("rishbrmnhkqqhdyb")
    public suspend fun routeSettings(`value`: List<StageRouteSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeSettings = mapped
    }

    /**
     * @param argument Route settings for the stage.
     */
    @JvmName("khaikyrftgahlqqp")
    public suspend fun routeSettings(argument: List<suspend StageRouteSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StageRouteSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routeSettings = mapped
    }

    /**
     * @param argument Route settings for the stage.
     */
    @JvmName("vwydgnyxwxsvgyfc")
    public suspend fun routeSettings(vararg argument: suspend StageRouteSettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            StageRouteSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routeSettings = mapped
    }

    /**
     * @param argument Route settings for the stage.
     */
    @JvmName("cgkxiqyytfconkdv")
    public suspend fun routeSettings(argument: suspend StageRouteSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StageRouteSettingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.routeSettings = mapped
    }

    /**
     * @param values Route settings for the stage.
     */
    @JvmName("keqcnkpujjrsiweh")
    public suspend fun routeSettings(vararg values: StageRouteSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routeSettings = mapped
    }

    /**
     * @param value Map that defines the stage variables for the stage.
     */
    @JvmName("qlgfadrhycacredo")
    public suspend fun stageVariables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stageVariables = mapped
    }

    /**
     * @param values Map that defines the stage variables for the stage.
     */
    @JvmName("kejnrjbbijtcmlab")
    public fun stageVariables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stageVariables = mapped
    }

    /**
     * @param value Map of tags to assign to the stage. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rooycdqppotwedcx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the stage. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("awxifhrjlxpqvtcj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): StageArgs = StageArgs(
        accessLogSettings = accessLogSettings,
        apiId = apiId,
        autoDeploy = autoDeploy,
        clientCertificateId = clientCertificateId,
        defaultRouteSettings = defaultRouteSettings,
        deploymentId = deploymentId,
        description = description,
        name = name,
        routeSettings = routeSettings,
        stageVariables = stageVariables,
        tags = tags,
    )
}
