@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.VpcLinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Amazon API Gateway Version 2 VPC Link.
 * > **Note:** Amazon API Gateway Version 2 VPC Links enable private integrations that connect HTTP APIs to private resources in a VPC.
 * To enable private integration for REST APIs, use the Amazon API Gateway Version 1 VPC Link resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apigatewayv2.VpcLink("example", {
 *     name: "example",
 *     securityGroupIds: [exampleAwsSecurityGroup&#46;id],
 *     subnetIds: exampleAwsSubnets.ids,
 *     tags: {
 *         Usage: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apigatewayv2.VpcLink("example",
 *     name="example",
 *     security_group_ids=[example_aws_security_group["id"]],
 *     subnet_ids=example_aws_subnets["ids"],
 *     tags={
 *         "Usage": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ApiGatewayV2.VpcLink("example", new()
 *     {
 *         Name = "example",
 *         SecurityGroupIds = new[]
 *         {
 *             exampleAwsSecurityGroup.Id,
 *         },
 *         SubnetIds = exampleAwsSubnets.Ids,
 *         Tags =
 *         {
 *             { "Usage", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigatewayv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigatewayv2.NewVpcLink(ctx, "example", &apigatewayv2.VpcLinkArgs{
 * 			Name: pulumi.String("example"),
 * 			SecurityGroupIds: pulumi.StringArray{
 * 				exampleAwsSecurityGroup.Id,
 * 			},
 * 			SubnetIds: pulumi.Any(exampleAwsSubnets.Ids),
 * 			Tags: pulumi.StringMap{
 * 				"Usage": pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.VpcLink;
 * import com.pulumi.aws.apigatewayv2.VpcLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcLink("example", VpcLinkArgs.builder()
 *             .name("example")
 *             .securityGroupIds(exampleAwsSecurityGroup.id())
 *             .subnetIds(exampleAwsSubnets.ids())
 *             .tags(Map.of("Usage", "example"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apigatewayv2:VpcLink
 *     properties:
 *       name: example
 *       securityGroupIds:
 *         - ${exampleAwsSecurityGroup.id}
 *       subnetIds: ${exampleAwsSubnets.ids}
 *       tags:
 *         Usage: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_vpc_link` using the VPC Link identifier. For example:
 * ```sh
 * $ pulumi import aws:apigatewayv2/vpcLink:VpcLink example aabbccddee
 * ```
 * @property name Name of the VPC Link. Must be between 1 and 128 characters in length.
 * @property securityGroupIds Security group IDs for the VPC Link.
 * @property subnetIds Subnet IDs for the VPC Link.
 * @property tags Map of tags to assign to the VPC Link. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class VpcLinkArgs(
    public val name: Output<String>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.VpcLinkArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.VpcLinkArgs =
        com.pulumi.aws.apigatewayv2.VpcLinkArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [VpcLinkArgs].
 */
@PulumiTagMarker
public class VpcLinkArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the VPC Link. Must be between 1 and 128 characters in length.
     */
    @JvmName("ndxlxuvbjovsybgd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Security group IDs for the VPC Link.
     */
    @JvmName("smscpwtxsvkmthet")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("lyuvyohvqlwvtqwe")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values Security group IDs for the VPC Link.
     */
    @JvmName("fgptoebmlpsfcibh")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value Subnet IDs for the VPC Link.
     */
    @JvmName("caufoqiufdrujjth")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("vnvyvohctdbcyseh")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values Subnet IDs for the VPC Link.
     */
    @JvmName("bxttdavudkhiguwa")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value Map of tags to assign to the VPC Link. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xoxxuuovbeswpwbu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the VPC Link. Must be between 1 and 128 characters in length.
     */
    @JvmName("kdssceyugoafpfno")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Security group IDs for the VPC Link.
     */
    @JvmName("drtkbjxpjfdhphml")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values Security group IDs for the VPC Link.
     */
    @JvmName("iudqaqwfxbnyfyoo")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value Subnet IDs for the VPC Link.
     */
    @JvmName("ocvpkokxxvkqrabl")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values Subnet IDs for the VPC Link.
     */
    @JvmName("pieyedusetscvhfk")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value Map of tags to assign to the VPC Link. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eosssvewsqtrlusc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the VPC Link. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("knykoveiqjpfsovr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): VpcLinkArgs = VpcLinkArgs(
        name = name,
        securityGroupIds = securityGroupIds,
        subnetIds = subnetIds,
        tags = tags,
    )
}
